// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.trafficmanager.models.Region;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Class representing the Geographic hierarchy used with the Geographic traffic routing method. */
@JsonFlatten
@Fluent
public class TrafficManagerGeographicHierarchyInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(TrafficManagerGeographicHierarchyInner.class);

    /*
     * The region at the root of the hierarchy from all the regions in the
     * hierarchy can be retrieved.
     */
    @JsonProperty(value = "properties.geographicHierarchy")
    private Region geographicHierarchy;

    /*
     * Fully qualified resource Id for the resource. Ex -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * The name of the resource
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    @JsonProperty(value = "type")
    private String type;

    /**
     * Get the geographicHierarchy property: The region at the root of the hierarchy from all the regions in the
     * hierarchy can be retrieved.
     *
     * @return the geographicHierarchy value.
     */
    public Region geographicHierarchy() {
        return this.geographicHierarchy;
    }

    /**
     * Set the geographicHierarchy property: The region at the root of the hierarchy from all the regions in the
     * hierarchy can be retrieved.
     *
     * @param geographicHierarchy the geographicHierarchy value to set.
     * @return the TrafficManagerGeographicHierarchyInner object itself.
     */
    public TrafficManagerGeographicHierarchyInner withGeographicHierarchy(Region geographicHierarchy) {
        this.geographicHierarchy = geographicHierarchy;
        return this;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource. Ex -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Fully qualified resource Id for the resource. Ex -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
     *
     * @param id the id value to set.
     * @return the TrafficManagerGeographicHierarchyInner object itself.
     */
    public TrafficManagerGeographicHierarchyInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource.
     *
     * @param name the name value to set.
     * @return the TrafficManagerGeographicHierarchyInner object itself.
     */
    public TrafficManagerGeographicHierarchyInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     *
     * @param type the type value to set.
     * @return the TrafficManagerGeographicHierarchyInner object itself.
     */
    public TrafficManagerGeographicHierarchyInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (geographicHierarchy() != null) {
            geographicHierarchy().validate();
        }
    }
}
