/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.Action;
import com.azure.resourcemanager.storage.models.State;
import java.io.IOException;

public final class VirtualNetworkRule
implements JsonSerializable<VirtualNetworkRule> {
    private String virtualNetworkResourceId;
    private Action action;
    private State state;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkRule.class);

    public String virtualNetworkResourceId() {
        return this.virtualNetworkResourceId;
    }

    public VirtualNetworkRule withVirtualNetworkResourceId(String virtualNetworkResourceId) {
        this.virtualNetworkResourceId = virtualNetworkResourceId;
        return this;
    }

    public Action action() {
        return this.action;
    }

    public VirtualNetworkRule withAction(Action action) {
        this.action = action;
        return this;
    }

    public State state() {
        return this.state;
    }

    public VirtualNetworkRule withState(State state) {
        this.state = state;
        return this;
    }

    public void validate() {
        if (this.virtualNetworkResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property virtualNetworkResourceId in model VirtualNetworkRule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.virtualNetworkResourceId);
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkRule fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkRule)jsonReader.readObject(reader -> {
            VirtualNetworkRule deserializedVirtualNetworkRule = new VirtualNetworkRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVirtualNetworkRule.virtualNetworkResourceId = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedVirtualNetworkRule.action = Action.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedVirtualNetworkRule.state = State.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkRule;
        });
    }
}

