/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.Kind;
import com.azure.resourcemanager.storage.models.Restriction;
import com.azure.resourcemanager.storage.models.SkuCapability;
import com.azure.resourcemanager.storage.models.SkuInformationLocationInfoItem;
import com.azure.resourcemanager.storage.models.SkuName;
import com.azure.resourcemanager.storage.models.SkuTier;
import java.io.IOException;
import java.util.List;

public final class SkuInformationInner
implements JsonSerializable<SkuInformationInner> {
    private SkuName name;
    private SkuTier tier;
    private String resourceType;
    private Kind kind;
    private List<String> locations;
    private List<SkuInformationLocationInfoItem> locationInfo;
    private List<SkuCapability> capabilities;
    private List<Restriction> restrictions;
    private static final ClientLogger LOGGER = new ClientLogger(SkuInformationInner.class);

    public SkuName name() {
        return this.name;
    }

    public SkuInformationInner withName(SkuName name) {
        this.name = name;
        return this;
    }

    public SkuTier tier() {
        return this.tier;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Kind kind() {
        return this.kind;
    }

    public List<String> locations() {
        return this.locations;
    }

    public List<SkuInformationLocationInfoItem> locationInfo() {
        return this.locationInfo;
    }

    public SkuInformationInner withLocationInfo(List<SkuInformationLocationInfoItem> locationInfo) {
        this.locationInfo = locationInfo;
        return this;
    }

    public List<SkuCapability> capabilities() {
        return this.capabilities;
    }

    public List<Restriction> restrictions() {
        return this.restrictions;
    }

    public SkuInformationInner withRestrictions(List<Restriction> restrictions) {
        this.restrictions = restrictions;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model SkuInformationInner"));
        }
        if (this.locationInfo() != null) {
            this.locationInfo().forEach(e -> e.validate());
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.restrictions() != null) {
            this.restrictions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeArrayField("locationInfo", this.locationInfo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("restrictions", this.restrictions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SkuInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return (SkuInformationInner)jsonReader.readObject(reader -> {
            SkuInformationInner deserializedSkuInformationInner = new SkuInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSkuInformationInner.name = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedSkuInformationInner.tier = SkuTier.fromString(reader.getString());
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedSkuInformationInner.resourceType = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedSkuInformationInner.kind = Kind.fromString(reader.getString());
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedSkuInformationInner.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("locationInfo".equals(fieldName)) {
                    List locationInfo;
                    deserializedSkuInformationInner.locationInfo = locationInfo = reader.readArray(reader1 -> SkuInformationLocationInfoItem.fromJson(reader1));
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedSkuInformationInner.capabilities = capabilities = reader.readArray(reader1 -> SkuCapability.fromJson(reader1));
                    continue;
                }
                if ("restrictions".equals(fieldName)) {
                    List restrictions;
                    deserializedSkuInformationInner.restrictions = restrictions = reader.readArray(reader1 -> Restriction.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuInformationInner;
        });
    }
}

