/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class QueueProperties
implements JsonSerializable<QueueProperties> {
    private Map<String, String> metadata;
    private Integer approximateMessageCount;

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public QueueProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Integer approximateMessageCount() {
        return this.approximateMessageCount;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static QueueProperties fromJson(JsonReader jsonReader) throws IOException {
        return (QueueProperties)jsonReader.readObject(reader -> {
            QueueProperties deserializedQueueProperties = new QueueProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedQueueProperties.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("approximateMessageCount".equals(fieldName)) {
                    deserializedQueueProperties.approximateMessageCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueueProperties;
        });
    }
}

