// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.storage.fluent.StorageTaskAssignmentsClient;
import com.azure.resourcemanager.storage.fluent.models.StorageTaskAssignmentInner;
import com.azure.resourcemanager.storage.models.StorageTaskAssignmentUpdateParameters;
import com.azure.resourcemanager.storage.models.StorageTaskAssignmentsList;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in StorageTaskAssignmentsClient.
 */
public final class StorageTaskAssignmentsClientImpl implements StorageTaskAssignmentsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final StorageTaskAssignmentsService service;

    /**
     * The service client containing this operation class.
     */
    private final StorageManagementClientImpl client;

    /**
     * Initializes an instance of StorageTaskAssignmentsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    StorageTaskAssignmentsClientImpl(StorageManagementClientImpl client) {
        this.service = RestProxy.create(StorageTaskAssignmentsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for StorageManagementClientStorageTaskAssignments to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "StorageManagementClientStorageTaskAssignments")
    public interface StorageTaskAssignmentsService {
        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/storageTaskAssignments/{storageTaskAssignmentName}")
        @ExpectedResponses({ 200, 201, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> create(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("storageTaskAssignmentName") String storageTaskAssignmentName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StorageTaskAssignmentInner parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/storageTaskAssignments/{storageTaskAssignmentName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("storageTaskAssignmentName") String storageTaskAssignmentName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StorageTaskAssignmentUpdateParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/storageTaskAssignments/{storageTaskAssignmentName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<StorageTaskAssignmentInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("storageTaskAssignmentName") String storageTaskAssignmentName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/storageTaskAssignments/{storageTaskAssignmentName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("storageTaskAssignmentName") String storageTaskAssignmentName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/storageTaskAssignments")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<StorageTaskAssignmentsList>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @QueryParam("$top") Integer top, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<StorageTaskAssignmentsList>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (storageTaskAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter storageTaskAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    accountName, storageTaskAssignmentName, this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (storageTaskAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter storageTaskAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            accountName, storageTaskAssignmentName, this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginCreateAsync(
        String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createWithResponseAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters);
        return this.client.<StorageTaskAssignmentInner, StorageTaskAssignmentInner>getLroResult(mono,
            this.client.getHttpPipeline(), StorageTaskAssignmentInner.class, StorageTaskAssignmentInner.class,
            this.client.getContext());
    }

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginCreateAsync(
        String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createWithResponseAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters, context);
        return this.client.<StorageTaskAssignmentInner, StorageTaskAssignmentInner>getLroResult(mono,
            this.client.getHttpPipeline(), StorageTaskAssignmentInner.class, StorageTaskAssignmentInner.class, context);
    }

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginCreate(
        String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentInner parameters) {
        return this.beginCreateAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters)
            .getSyncPoller();
    }

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginCreate(
        String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentInner parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters, context)
            .getSyncPoller();
    }

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StorageTaskAssignmentInner> createAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentInner parameters) {
        return beginCreateAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<StorageTaskAssignmentInner> createAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentInner parameters, Context context) {
        return beginCreateAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StorageTaskAssignmentInner create(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentInner parameters) {
        return createAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters).block();
    }

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StorageTaskAssignmentInner create(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentInner parameters, Context context) {
        return createAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters, context).block();
    }

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentUpdateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (storageTaskAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter storageTaskAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    accountName, storageTaskAssignmentName, this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentUpdateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (storageTaskAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter storageTaskAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            accountName, storageTaskAssignmentName, this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginUpdateAsync(
        String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentUpdateParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters);
        return this.client.<StorageTaskAssignmentInner, StorageTaskAssignmentInner>getLroResult(mono,
            this.client.getHttpPipeline(), StorageTaskAssignmentInner.class, StorageTaskAssignmentInner.class,
            this.client.getContext());
    }

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginUpdateAsync(
        String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentUpdateParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters, context);
        return this.client.<StorageTaskAssignmentInner, StorageTaskAssignmentInner>getLroResult(mono,
            this.client.getHttpPipeline(), StorageTaskAssignmentInner.class, StorageTaskAssignmentInner.class, context);
    }

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginUpdate(
        String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentUpdateParameters parameters) {
        return this.beginUpdateAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters)
            .getSyncPoller();
    }

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginUpdate(
        String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentUpdateParameters parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters, context)
            .getSyncPoller();
    }

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StorageTaskAssignmentInner> updateAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentUpdateParameters parameters) {
        return beginUpdateAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<StorageTaskAssignmentInner> updateAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentUpdateParameters parameters, Context context) {
        return beginUpdateAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StorageTaskAssignmentInner update(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentUpdateParameters parameters) {
        return updateAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters).block();
    }

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StorageTaskAssignmentInner update(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentUpdateParameters parameters, Context context) {
        return updateAsync(resourceGroupName, accountName, storageTaskAssignmentName, parameters, context).block();
    }

    /**
     * Get the storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment properties along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<StorageTaskAssignmentInner>> getWithResponseAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (storageTaskAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter storageTaskAssignmentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    accountName, storageTaskAssignmentName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment properties along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<StorageTaskAssignmentInner>> getWithResponseAsync(String resourceGroupName,
        String accountName, String storageTaskAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (storageTaskAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter storageTaskAssignmentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName,
            storageTaskAssignmentName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get the storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment properties on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StorageTaskAssignmentInner> getAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName) {
        return getWithResponseAsync(resourceGroupName, accountName, storageTaskAssignmentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment properties along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<StorageTaskAssignmentInner> getWithResponse(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, Context context) {
        return getWithResponseAsync(resourceGroupName, accountName, storageTaskAssignmentName, context).block();
    }

    /**
     * Get the storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StorageTaskAssignmentInner get(String resourceGroupName, String accountName,
        String storageTaskAssignmentName) {
        return getWithResponse(resourceGroupName, accountName, storageTaskAssignmentName, Context.NONE).getValue();
    }

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (storageTaskAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter storageTaskAssignmentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    accountName, storageTaskAssignmentName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (storageTaskAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter storageTaskAssignmentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            accountName, storageTaskAssignmentName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, accountName, storageTaskAssignmentName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, accountName, storageTaskAssignmentName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName,
        String storageTaskAssignmentName) {
        return this.beginDeleteAsync(resourceGroupName, accountName, storageTaskAssignmentName).getSyncPoller();
    }

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, accountName, storageTaskAssignmentName, context)
            .getSyncPoller();
    }

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String accountName, String storageTaskAssignmentName) {
        return beginDeleteAsync(resourceGroupName, accountName, storageTaskAssignmentName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String accountName, String storageTaskAssignmentName,
        Context context) {
        return beginDeleteAsync(resourceGroupName, accountName, storageTaskAssignmentName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String storageTaskAssignmentName) {
        deleteAsync(resourceGroupName, accountName, storageTaskAssignmentName).block();
    }

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String storageTaskAssignmentName,
        Context context) {
        deleteAsync(resourceGroupName, accountName, storageTaskAssignmentName, context).block();
    }

    /**
     * List all the storage task assignments in an account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param top Optional, specifies the maximum number of storage task assignment Ids to be included in the list
     * response.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StorageTaskAssignmentInner>> listSinglePageAsync(String resourceGroupName,
        String accountName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, accountName, top, this.client.getApiVersion(), accept, context))
            .<PagedResponse<StorageTaskAssignmentInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List all the storage task assignments in an account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param top Optional, specifies the maximum number of storage task assignment Ids to be included in the list
     * response.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StorageTaskAssignmentInner>> listSinglePageAsync(String resourceGroupName,
        String accountName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, top,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List all the storage task assignments in an account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param top Optional, specifies the maximum number of storage task assignment Ids to be included in the list
     * response.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StorageTaskAssignmentInner> listAsync(String resourceGroupName, String accountName, Integer top) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, accountName, top),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * List all the storage task assignments in an account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<StorageTaskAssignmentInner> listAsync(String resourceGroupName, String accountName) {
        final Integer top = null;
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, accountName, top),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * List all the storage task assignments in an account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param top Optional, specifies the maximum number of storage task assignment Ids to be included in the list
     * response.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<StorageTaskAssignmentInner> listAsync(String resourceGroupName, String accountName, Integer top,
        Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, accountName, top, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * List all the storage task assignments in an account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StorageTaskAssignmentInner> list(String resourceGroupName, String accountName) {
        final Integer top = null;
        return new PagedIterable<>(listAsync(resourceGroupName, accountName, top));
    }

    /**
     * List all the storage task assignments in an account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param top Optional, specifies the maximum number of storage task assignment Ids to be included in the list
     * response.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<StorageTaskAssignmentInner> list(String resourceGroupName, String accountName, Integer top,
        Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, accountName, top, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StorageTaskAssignmentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<StorageTaskAssignmentInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<StorageTaskAssignmentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
