// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.AccessTier;
import com.azure.resourcemanager.storage.models.AccountStatus;
import com.azure.resourcemanager.storage.models.AllowedCopyScope;
import com.azure.resourcemanager.storage.models.AzureFilesIdentityBasedAuthentication;
import com.azure.resourcemanager.storage.models.CustomDomain;
import com.azure.resourcemanager.storage.models.DnsEndpointType;
import com.azure.resourcemanager.storage.models.DualStackEndpointPreference;
import com.azure.resourcemanager.storage.models.Encryption;
import com.azure.resourcemanager.storage.models.Endpoints;
import com.azure.resourcemanager.storage.models.GeoPriorityReplicationStatus;
import com.azure.resourcemanager.storage.models.GeoReplicationStats;
import com.azure.resourcemanager.storage.models.ImmutableStorageAccount;
import com.azure.resourcemanager.storage.models.KeyCreationTime;
import com.azure.resourcemanager.storage.models.KeyPolicy;
import com.azure.resourcemanager.storage.models.LargeFileSharesState;
import com.azure.resourcemanager.storage.models.MinimumTlsVersion;
import com.azure.resourcemanager.storage.models.NetworkRuleSet;
import com.azure.resourcemanager.storage.models.ProvisioningState;
import com.azure.resourcemanager.storage.models.PublicNetworkAccess;
import com.azure.resourcemanager.storage.models.RoutingPreference;
import com.azure.resourcemanager.storage.models.SasPolicy;
import com.azure.resourcemanager.storage.models.StorageAccountSkuConversionStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Properties of the storage account.
 */
@Fluent
public final class StorageAccountPropertiesInner implements JsonSerializable<StorageAccountPropertiesInner> {
    /*
     * Gets the status of the storage account at the time the operation was called.
     */
    private ProvisioningState provisioningState;

    /*
     * Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object. Note that
     * Standard_ZRS and Premium_LRS accounts only return the blob endpoint.
     */
    private Endpoints primaryEndpoints;

    /*
     * Gets the location of the primary data center for the storage account.
     */
    private String primaryLocation;

    /*
     * Gets the status indicating whether the primary location of the storage account is available or unavailable.
     */
    private AccountStatus statusOfPrimary;

    /*
     * Gets the timestamp of the most recent instance of a failover to the secondary location. Only the most recent
     * timestamp is retained. This element is not returned if there has never been a failover instance. Only available
     * if the accountType is Standard_GRS or Standard_RAGRS.
     */
    private OffsetDateTime lastGeoFailoverTime;

    /*
     * Gets the location of the geo-replicated secondary for the storage account. Only available if the accountType is
     * Standard_GRS or Standard_RAGRS.
     */
    private String secondaryLocation;

    /*
     * Gets the status indicating whether the secondary location of the storage account is available or unavailable.
     * Only available if the SKU name is Standard_GRS or Standard_RAGRS.
     */
    private AccountStatus statusOfSecondary;

    /*
     * Gets the creation date and time of the storage account in UTC.
     */
    private OffsetDateTime creationTime;

    /*
     * Gets the custom domain the user assigned to this storage account.
     */
    private CustomDomain customDomain;

    /*
     * SasPolicy assigned to the storage account.
     */
    private SasPolicy sasPolicy;

    /*
     * KeyPolicy assigned to the storage account.
     */
    private KeyPolicy keyPolicy;

    /*
     * Storage account keys creation time.
     */
    private KeyCreationTime keyCreationTime;

    /*
     * Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object from the secondary
     * location of the storage account. Only available if the SKU name is Standard_RAGRS.
     */
    private Endpoints secondaryEndpoints;

    /*
     * Encryption settings to be used for server-side encryption for the storage account.
     */
    private Encryption encryption;

    /*
     * Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access
     * tier is the default value for premium block blobs storage account type and it cannot be changed for the premium
     * block blobs storage account type.
     */
    private AccessTier accessTier;

    /*
     * Provides the identity based authentication settings for Azure Files.
     */
    private AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication;

    /*
     * Allows https traffic only to storage service if sets to true.
     */
    private Boolean enableHttpsTrafficOnly;

    /*
     * Network rule set
     */
    private NetworkRuleSet networkRuleSet;

    /*
     * Enables Secure File Transfer Protocol, if set to true
     */
    private Boolean isSftpEnabled;

    /*
     * Enables local users feature, if set to true
     */
    private Boolean isLocalUserEnabled;

    /*
     * Enables extended group support with local users feature, if set to true
     */
    private Boolean enableExtendedGroups;

    /*
     * Account HierarchicalNamespace enabled if sets to true.
     */
    private Boolean isHnsEnabled;

    /*
     * Geo Replication Stats
     */
    private GeoReplicationStats geoReplicationStats;

    /*
     * If the failover is in progress, the value will be true, otherwise, it will be null.
     */
    private Boolean failoverInProgress;

    /*
     * Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
     */
    private LargeFileSharesState largeFileSharesState;

    /*
     * List of private endpoint connection associated with the specified storage account
     */
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    /*
     * Maintains information about the network routing choice opted by the user for data transfer
     */
    private RoutingPreference routingPreference;

    /*
     * Maintains information about the Internet protocol opted by the user.
     */
    private DualStackEndpointPreference dualStackEndpointPreference;

    /*
     * Blob restore status
     */
    private BlobRestoreStatusInner blobRestoreStatus;

    /*
     * Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is
     * false for this property.
     */
    private Boolean allowBlobPublicAccess;

    /*
     * Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for
     * this property.
     */
    private MinimumTlsVersion minimumTlsVersion;

    /*
     * Indicates whether the storage account permits requests to be authorized with the account access key via Shared
     * Key. If false, then all requests, including shared access signatures, must be authorized with Azure Active
     * Directory (Azure AD). The default value is null, which is equivalent to true.
     */
    private Boolean allowSharedKeyAccess;

    /*
     * NFS 3.0 protocol support enabled if set to true.
     */
    private Boolean enableNfsV3;

    /*
     * Allow or disallow cross AAD tenant object replication. Set this property to true for new or existing accounts
     * only if object replication policies will involve storage accounts in different AAD tenants. The default
     * interpretation is false for new accounts to follow best security practices by default.
     */
    private Boolean allowCrossTenantReplication;

    /*
     * A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is
     * false for this property.
     */
    private Boolean defaultToOAuthAuthentication;

    /*
     * Allow, disallow, or let Network Security Perimeter configuration to evaluate public network access to Storage
     * Account.
     */
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * The property is immutable and can only be set to true at the account creation time. When set to true, it enables
     * object level immutability for all the containers in the account by default.
     */
    private ImmutableStorageAccount immutableStorageWithVersioning;

    /*
     * Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
     */
    private AllowedCopyScope allowedCopyScope;

    /*
     * This property is readOnly and is set by server during asynchronous storage account sku conversion operations.
     */
    private StorageAccountSkuConversionStatus storageAccountSkuConversionStatus;

    /*
     * Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a
     * single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric
     * DNS Zone identifier.
     */
    private DnsEndpointType dnsEndpointType;

    /*
     * This property will be set to true or false on an event of ongoing migration. Default value is null.
     */
    private Boolean isSkuConversionBlocked;

    /*
     * If customer initiated account migration is in progress, the value will be true else it will be null.
     */
    private Boolean accountMigrationInProgress;

    /*
     * Status indicating whether Geo Priority Replication is enabled for the account.
     */
    private GeoPriorityReplicationStatus geoPriorityReplicationStatus;

    /**
     * Creates an instance of StorageAccountPropertiesInner class.
     */
    public StorageAccountPropertiesInner() {
    }

    /**
     * Get the provisioningState property: Gets the status of the storage account at the time the operation was called.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the primaryEndpoints property: Gets the URLs that are used to perform a retrieval of a public blob, queue, or
     * table object. Note that Standard_ZRS and Premium_LRS accounts only return the blob endpoint.
     * 
     * @return the primaryEndpoints value.
     */
    public Endpoints primaryEndpoints() {
        return this.primaryEndpoints;
    }

    /**
     * Get the primaryLocation property: Gets the location of the primary data center for the storage account.
     * 
     * @return the primaryLocation value.
     */
    public String primaryLocation() {
        return this.primaryLocation;
    }

    /**
     * Get the statusOfPrimary property: Gets the status indicating whether the primary location of the storage account
     * is available or unavailable.
     * 
     * @return the statusOfPrimary value.
     */
    public AccountStatus statusOfPrimary() {
        return this.statusOfPrimary;
    }

    /**
     * Get the lastGeoFailoverTime property: Gets the timestamp of the most recent instance of a failover to the
     * secondary location. Only the most recent timestamp is retained. This element is not returned if there has never
     * been a failover instance. Only available if the accountType is Standard_GRS or Standard_RAGRS.
     * 
     * @return the lastGeoFailoverTime value.
     */
    public OffsetDateTime lastGeoFailoverTime() {
        return this.lastGeoFailoverTime;
    }

    /**
     * Get the secondaryLocation property: Gets the location of the geo-replicated secondary for the storage account.
     * Only available if the accountType is Standard_GRS or Standard_RAGRS.
     * 
     * @return the secondaryLocation value.
     */
    public String secondaryLocation() {
        return this.secondaryLocation;
    }

    /**
     * Get the statusOfSecondary property: Gets the status indicating whether the secondary location of the storage
     * account is available or unavailable. Only available if the SKU name is Standard_GRS or Standard_RAGRS.
     * 
     * @return the statusOfSecondary value.
     */
    public AccountStatus statusOfSecondary() {
        return this.statusOfSecondary;
    }

    /**
     * Get the creationTime property: Gets the creation date and time of the storage account in UTC.
     * 
     * @return the creationTime value.
     */
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Get the customDomain property: Gets the custom domain the user assigned to this storage account.
     * 
     * @return the customDomain value.
     */
    public CustomDomain customDomain() {
        return this.customDomain;
    }

    /**
     * Get the sasPolicy property: SasPolicy assigned to the storage account.
     * 
     * @return the sasPolicy value.
     */
    public SasPolicy sasPolicy() {
        return this.sasPolicy;
    }

    /**
     * Get the keyPolicy property: KeyPolicy assigned to the storage account.
     * 
     * @return the keyPolicy value.
     */
    public KeyPolicy keyPolicy() {
        return this.keyPolicy;
    }

    /**
     * Get the keyCreationTime property: Storage account keys creation time.
     * 
     * @return the keyCreationTime value.
     */
    public KeyCreationTime keyCreationTime() {
        return this.keyCreationTime;
    }

    /**
     * Get the secondaryEndpoints property: Gets the URLs that are used to perform a retrieval of a public blob, queue,
     * or table object from the secondary location of the storage account. Only available if the SKU name is
     * Standard_RAGRS.
     * 
     * @return the secondaryEndpoints value.
     */
    public Endpoints secondaryEndpoints() {
        return this.secondaryEndpoints;
    }

    /**
     * Get the encryption property: Encryption settings to be used for server-side encryption for the storage account.
     * 
     * @return the encryption value.
     */
    public Encryption encryption() {
        return this.encryption;
    }

    /**
     * Get the accessTier property: Required for storage accounts where kind = BlobStorage. The access tier is used for
     * billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it
     * cannot be changed for the premium block blobs storage account type.
     * 
     * @return the accessTier value.
     */
    public AccessTier accessTier() {
        return this.accessTier;
    }

    /**
     * Get the azureFilesIdentityBasedAuthentication property: Provides the identity based authentication settings for
     * Azure Files.
     * 
     * @return the azureFilesIdentityBasedAuthentication value.
     */
    public AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication() {
        return this.azureFilesIdentityBasedAuthentication;
    }

    /**
     * Set the azureFilesIdentityBasedAuthentication property: Provides the identity based authentication settings for
     * Azure Files.
     * 
     * @param azureFilesIdentityBasedAuthentication the azureFilesIdentityBasedAuthentication value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withAzureFilesIdentityBasedAuthentication(
        AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication) {
        this.azureFilesIdentityBasedAuthentication = azureFilesIdentityBasedAuthentication;
        return this;
    }

    /**
     * Get the enableHttpsTrafficOnly property: Allows https traffic only to storage service if sets to true.
     * 
     * @return the enableHttpsTrafficOnly value.
     */
    public Boolean enableHttpsTrafficOnly() {
        return this.enableHttpsTrafficOnly;
    }

    /**
     * Set the enableHttpsTrafficOnly property: Allows https traffic only to storage service if sets to true.
     * 
     * @param enableHttpsTrafficOnly the enableHttpsTrafficOnly value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withEnableHttpsTrafficOnly(Boolean enableHttpsTrafficOnly) {
        this.enableHttpsTrafficOnly = enableHttpsTrafficOnly;
        return this;
    }

    /**
     * Get the networkRuleSet property: Network rule set.
     * 
     * @return the networkRuleSet value.
     */
    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    /**
     * Get the isSftpEnabled property: Enables Secure File Transfer Protocol, if set to true.
     * 
     * @return the isSftpEnabled value.
     */
    public Boolean isSftpEnabled() {
        return this.isSftpEnabled;
    }

    /**
     * Set the isSftpEnabled property: Enables Secure File Transfer Protocol, if set to true.
     * 
     * @param isSftpEnabled the isSftpEnabled value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withIsSftpEnabled(Boolean isSftpEnabled) {
        this.isSftpEnabled = isSftpEnabled;
        return this;
    }

    /**
     * Get the isLocalUserEnabled property: Enables local users feature, if set to true.
     * 
     * @return the isLocalUserEnabled value.
     */
    public Boolean isLocalUserEnabled() {
        return this.isLocalUserEnabled;
    }

    /**
     * Set the isLocalUserEnabled property: Enables local users feature, if set to true.
     * 
     * @param isLocalUserEnabled the isLocalUserEnabled value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withIsLocalUserEnabled(Boolean isLocalUserEnabled) {
        this.isLocalUserEnabled = isLocalUserEnabled;
        return this;
    }

    /**
     * Get the enableExtendedGroups property: Enables extended group support with local users feature, if set to true.
     * 
     * @return the enableExtendedGroups value.
     */
    public Boolean enableExtendedGroups() {
        return this.enableExtendedGroups;
    }

    /**
     * Set the enableExtendedGroups property: Enables extended group support with local users feature, if set to true.
     * 
     * @param enableExtendedGroups the enableExtendedGroups value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withEnableExtendedGroups(Boolean enableExtendedGroups) {
        this.enableExtendedGroups = enableExtendedGroups;
        return this;
    }

    /**
     * Get the isHnsEnabled property: Account HierarchicalNamespace enabled if sets to true.
     * 
     * @return the isHnsEnabled value.
     */
    public Boolean isHnsEnabled() {
        return this.isHnsEnabled;
    }

    /**
     * Set the isHnsEnabled property: Account HierarchicalNamespace enabled if sets to true.
     * 
     * @param isHnsEnabled the isHnsEnabled value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withIsHnsEnabled(Boolean isHnsEnabled) {
        this.isHnsEnabled = isHnsEnabled;
        return this;
    }

    /**
     * Get the geoReplicationStats property: Geo Replication Stats.
     * 
     * @return the geoReplicationStats value.
     */
    public GeoReplicationStats geoReplicationStats() {
        return this.geoReplicationStats;
    }

    /**
     * Get the failoverInProgress property: If the failover is in progress, the value will be true, otherwise, it will
     * be null.
     * 
     * @return the failoverInProgress value.
     */
    public Boolean failoverInProgress() {
        return this.failoverInProgress;
    }

    /**
     * Get the largeFileSharesState property: Allow large file shares if sets to Enabled. It cannot be disabled once it
     * is enabled.
     * 
     * @return the largeFileSharesState value.
     */
    public LargeFileSharesState largeFileSharesState() {
        return this.largeFileSharesState;
    }

    /**
     * Set the largeFileSharesState property: Allow large file shares if sets to Enabled. It cannot be disabled once it
     * is enabled.
     * 
     * @param largeFileSharesState the largeFileSharesState value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withLargeFileSharesState(LargeFileSharesState largeFileSharesState) {
        this.largeFileSharesState = largeFileSharesState;
        return this;
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connection associated with the specified
     * storage account.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the routingPreference property: Maintains information about the network routing choice opted by the user for
     * data transfer.
     * 
     * @return the routingPreference value.
     */
    public RoutingPreference routingPreference() {
        return this.routingPreference;
    }

    /**
     * Set the routingPreference property: Maintains information about the network routing choice opted by the user for
     * data transfer.
     * 
     * @param routingPreference the routingPreference value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withRoutingPreference(RoutingPreference routingPreference) {
        this.routingPreference = routingPreference;
        return this;
    }

    /**
     * Get the dualStackEndpointPreference property: Maintains information about the Internet protocol opted by the
     * user.
     * 
     * @return the dualStackEndpointPreference value.
     */
    public DualStackEndpointPreference dualStackEndpointPreference() {
        return this.dualStackEndpointPreference;
    }

    /**
     * Set the dualStackEndpointPreference property: Maintains information about the Internet protocol opted by the
     * user.
     * 
     * @param dualStackEndpointPreference the dualStackEndpointPreference value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner
        withDualStackEndpointPreference(DualStackEndpointPreference dualStackEndpointPreference) {
        this.dualStackEndpointPreference = dualStackEndpointPreference;
        return this;
    }

    /**
     * Get the blobRestoreStatus property: Blob restore status.
     * 
     * @return the blobRestoreStatus value.
     */
    public BlobRestoreStatusInner blobRestoreStatus() {
        return this.blobRestoreStatus;
    }

    /**
     * Get the allowBlobPublicAccess property: Allow or disallow public access to all blobs or containers in the storage
     * account. The default interpretation is false for this property.
     * 
     * @return the allowBlobPublicAccess value.
     */
    public Boolean allowBlobPublicAccess() {
        return this.allowBlobPublicAccess;
    }

    /**
     * Set the allowBlobPublicAccess property: Allow or disallow public access to all blobs or containers in the storage
     * account. The default interpretation is false for this property.
     * 
     * @param allowBlobPublicAccess the allowBlobPublicAccess value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withAllowBlobPublicAccess(Boolean allowBlobPublicAccess) {
        this.allowBlobPublicAccess = allowBlobPublicAccess;
        return this;
    }

    /**
     * Get the minimumTlsVersion property: Set the minimum TLS version to be permitted on requests to storage. The
     * default interpretation is TLS 1.0 for this property.
     * 
     * @return the minimumTlsVersion value.
     */
    public MinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    /**
     * Set the minimumTlsVersion property: Set the minimum TLS version to be permitted on requests to storage. The
     * default interpretation is TLS 1.0 for this property.
     * 
     * @param minimumTlsVersion the minimumTlsVersion value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    /**
     * Get the allowSharedKeyAccess property: Indicates whether the storage account permits requests to be authorized
     * with the account access key via Shared Key. If false, then all requests, including shared access signatures, must
     * be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
     * 
     * @return the allowSharedKeyAccess value.
     */
    public Boolean allowSharedKeyAccess() {
        return this.allowSharedKeyAccess;
    }

    /**
     * Set the allowSharedKeyAccess property: Indicates whether the storage account permits requests to be authorized
     * with the account access key via Shared Key. If false, then all requests, including shared access signatures, must
     * be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
     * 
     * @param allowSharedKeyAccess the allowSharedKeyAccess value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withAllowSharedKeyAccess(Boolean allowSharedKeyAccess) {
        this.allowSharedKeyAccess = allowSharedKeyAccess;
        return this;
    }

    /**
     * Get the enableNfsV3 property: NFS 3.0 protocol support enabled if set to true.
     * 
     * @return the enableNfsV3 value.
     */
    public Boolean enableNfsV3() {
        return this.enableNfsV3;
    }

    /**
     * Set the enableNfsV3 property: NFS 3.0 protocol support enabled if set to true.
     * 
     * @param enableNfsV3 the enableNfsV3 value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withEnableNfsV3(Boolean enableNfsV3) {
        this.enableNfsV3 = enableNfsV3;
        return this;
    }

    /**
     * Get the allowCrossTenantReplication property: Allow or disallow cross AAD tenant object replication. Set this
     * property to true for new or existing accounts only if object replication policies will involve storage accounts
     * in different AAD tenants. The default interpretation is false for new accounts to follow best security practices
     * by default.
     * 
     * @return the allowCrossTenantReplication value.
     */
    public Boolean allowCrossTenantReplication() {
        return this.allowCrossTenantReplication;
    }

    /**
     * Set the allowCrossTenantReplication property: Allow or disallow cross AAD tenant object replication. Set this
     * property to true for new or existing accounts only if object replication policies will involve storage accounts
     * in different AAD tenants. The default interpretation is false for new accounts to follow best security practices
     * by default.
     * 
     * @param allowCrossTenantReplication the allowCrossTenantReplication value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withAllowCrossTenantReplication(Boolean allowCrossTenantReplication) {
        this.allowCrossTenantReplication = allowCrossTenantReplication;
        return this;
    }

    /**
     * Get the defaultToOAuthAuthentication property: A boolean flag which indicates whether the default authentication
     * is OAuth or not. The default interpretation is false for this property.
     * 
     * @return the defaultToOAuthAuthentication value.
     */
    public Boolean defaultToOAuthAuthentication() {
        return this.defaultToOAuthAuthentication;
    }

    /**
     * Set the defaultToOAuthAuthentication property: A boolean flag which indicates whether the default authentication
     * is OAuth or not. The default interpretation is false for this property.
     * 
     * @param defaultToOAuthAuthentication the defaultToOAuthAuthentication value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withDefaultToOAuthAuthentication(Boolean defaultToOAuthAuthentication) {
        this.defaultToOAuthAuthentication = defaultToOAuthAuthentication;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Allow, disallow, or let Network Security Perimeter configuration to
     * evaluate public network access to Storage Account.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Allow, disallow, or let Network Security Perimeter configuration to
     * evaluate public network access to Storage Account.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the immutableStorageWithVersioning property: The property is immutable and can only be set to true at the
     * account creation time. When set to true, it enables object level immutability for all the containers in the
     * account by default.
     * 
     * @return the immutableStorageWithVersioning value.
     */
    public ImmutableStorageAccount immutableStorageWithVersioning() {
        return this.immutableStorageWithVersioning;
    }

    /**
     * Set the immutableStorageWithVersioning property: The property is immutable and can only be set to true at the
     * account creation time. When set to true, it enables object level immutability for all the containers in the
     * account by default.
     * 
     * @param immutableStorageWithVersioning the immutableStorageWithVersioning value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner
        withImmutableStorageWithVersioning(ImmutableStorageAccount immutableStorageWithVersioning) {
        this.immutableStorageWithVersioning = immutableStorageWithVersioning;
        return this;
    }

    /**
     * Get the allowedCopyScope property: Restrict copy to and from Storage Accounts within an AAD tenant or with
     * Private Links to the same VNet.
     * 
     * @return the allowedCopyScope value.
     */
    public AllowedCopyScope allowedCopyScope() {
        return this.allowedCopyScope;
    }

    /**
     * Set the allowedCopyScope property: Restrict copy to and from Storage Accounts within an AAD tenant or with
     * Private Links to the same VNet.
     * 
     * @param allowedCopyScope the allowedCopyScope value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withAllowedCopyScope(AllowedCopyScope allowedCopyScope) {
        this.allowedCopyScope = allowedCopyScope;
        return this;
    }

    /**
     * Get the storageAccountSkuConversionStatus property: This property is readOnly and is set by server during
     * asynchronous storage account sku conversion operations.
     * 
     * @return the storageAccountSkuConversionStatus value.
     */
    public StorageAccountSkuConversionStatus storageAccountSkuConversionStatus() {
        return this.storageAccountSkuConversionStatus;
    }

    /**
     * Set the storageAccountSkuConversionStatus property: This property is readOnly and is set by server during
     * asynchronous storage account sku conversion operations.
     * 
     * @param storageAccountSkuConversionStatus the storageAccountSkuConversionStatus value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner
        withStorageAccountSkuConversionStatus(StorageAccountSkuConversionStatus storageAccountSkuConversionStatus) {
        this.storageAccountSkuConversionStatus = storageAccountSkuConversionStatus;
        return this;
    }

    /**
     * Get the dnsEndpointType property: Allows you to specify the type of endpoint. Set this to AzureDNSZone to create
     * a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint
     * URL will have an alphanumeric DNS Zone identifier.
     * 
     * @return the dnsEndpointType value.
     */
    public DnsEndpointType dnsEndpointType() {
        return this.dnsEndpointType;
    }

    /**
     * Set the dnsEndpointType property: Allows you to specify the type of endpoint. Set this to AzureDNSZone to create
     * a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint
     * URL will have an alphanumeric DNS Zone identifier.
     * 
     * @param dnsEndpointType the dnsEndpointType value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner withDnsEndpointType(DnsEndpointType dnsEndpointType) {
        this.dnsEndpointType = dnsEndpointType;
        return this;
    }

    /**
     * Get the isSkuConversionBlocked property: This property will be set to true or false on an event of ongoing
     * migration. Default value is null.
     * 
     * @return the isSkuConversionBlocked value.
     */
    public Boolean isSkuConversionBlocked() {
        return this.isSkuConversionBlocked;
    }

    /**
     * Get the accountMigrationInProgress property: If customer initiated account migration is in progress, the value
     * will be true else it will be null.
     * 
     * @return the accountMigrationInProgress value.
     */
    public Boolean accountMigrationInProgress() {
        return this.accountMigrationInProgress;
    }

    /**
     * Get the geoPriorityReplicationStatus property: Status indicating whether Geo Priority Replication is enabled for
     * the account.
     * 
     * @return the geoPriorityReplicationStatus value.
     */
    public GeoPriorityReplicationStatus geoPriorityReplicationStatus() {
        return this.geoPriorityReplicationStatus;
    }

    /**
     * Set the geoPriorityReplicationStatus property: Status indicating whether Geo Priority Replication is enabled for
     * the account.
     * 
     * @param geoPriorityReplicationStatus the geoPriorityReplicationStatus value to set.
     * @return the StorageAccountPropertiesInner object itself.
     */
    public StorageAccountPropertiesInner
        withGeoPriorityReplicationStatus(GeoPriorityReplicationStatus geoPriorityReplicationStatus) {
        this.geoPriorityReplicationStatus = geoPriorityReplicationStatus;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (primaryEndpoints() != null) {
            primaryEndpoints().validate();
        }
        if (customDomain() != null) {
            customDomain().validate();
        }
        if (sasPolicy() != null) {
            sasPolicy().validate();
        }
        if (keyPolicy() != null) {
            keyPolicy().validate();
        }
        if (keyCreationTime() != null) {
            keyCreationTime().validate();
        }
        if (secondaryEndpoints() != null) {
            secondaryEndpoints().validate();
        }
        if (encryption() != null) {
            encryption().validate();
        }
        if (azureFilesIdentityBasedAuthentication() != null) {
            azureFilesIdentityBasedAuthentication().validate();
        }
        if (networkRuleSet() != null) {
            networkRuleSet().validate();
        }
        if (geoReplicationStats() != null) {
            geoReplicationStats().validate();
        }
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
        if (routingPreference() != null) {
            routingPreference().validate();
        }
        if (dualStackEndpointPreference() != null) {
            dualStackEndpointPreference().validate();
        }
        if (blobRestoreStatus() != null) {
            blobRestoreStatus().validate();
        }
        if (immutableStorageWithVersioning() != null) {
            immutableStorageWithVersioning().validate();
        }
        if (storageAccountSkuConversionStatus() != null) {
            storageAccountSkuConversionStatus().validate();
        }
        if (geoPriorityReplicationStatus() != null) {
            geoPriorityReplicationStatus().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azureFilesIdentityBasedAuthentication", this.azureFilesIdentityBasedAuthentication);
        jsonWriter.writeBooleanField("supportsHttpsTrafficOnly", this.enableHttpsTrafficOnly);
        jsonWriter.writeBooleanField("isSftpEnabled", this.isSftpEnabled);
        jsonWriter.writeBooleanField("isLocalUserEnabled", this.isLocalUserEnabled);
        jsonWriter.writeBooleanField("enableExtendedGroups", this.enableExtendedGroups);
        jsonWriter.writeBooleanField("isHnsEnabled", this.isHnsEnabled);
        jsonWriter.writeStringField("largeFileSharesState",
            this.largeFileSharesState == null ? null : this.largeFileSharesState.toString());
        jsonWriter.writeJsonField("routingPreference", this.routingPreference);
        jsonWriter.writeJsonField("dualStackEndpointPreference", this.dualStackEndpointPreference);
        jsonWriter.writeBooleanField("allowBlobPublicAccess", this.allowBlobPublicAccess);
        jsonWriter.writeStringField("minimumTlsVersion",
            this.minimumTlsVersion == null ? null : this.minimumTlsVersion.toString());
        jsonWriter.writeBooleanField("allowSharedKeyAccess", this.allowSharedKeyAccess);
        jsonWriter.writeBooleanField("isNfsV3Enabled", this.enableNfsV3);
        jsonWriter.writeBooleanField("allowCrossTenantReplication", this.allowCrossTenantReplication);
        jsonWriter.writeBooleanField("defaultToOAuthAuthentication", this.defaultToOAuthAuthentication);
        jsonWriter.writeStringField("publicNetworkAccess",
            this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("immutableStorageWithVersioning", this.immutableStorageWithVersioning);
        jsonWriter.writeStringField("allowedCopyScope",
            this.allowedCopyScope == null ? null : this.allowedCopyScope.toString());
        jsonWriter.writeJsonField("storageAccountSkuConversionStatus", this.storageAccountSkuConversionStatus);
        jsonWriter.writeStringField("dnsEndpointType",
            this.dnsEndpointType == null ? null : this.dnsEndpointType.toString());
        jsonWriter.writeJsonField("geoPriorityReplicationStatus", this.geoPriorityReplicationStatus);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageAccountPropertiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageAccountPropertiesInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageAccountPropertiesInner.
     */
    public static StorageAccountPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageAccountPropertiesInner deserializedStorageAccountPropertiesInner
                = new StorageAccountPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("primaryEndpoints".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.primaryEndpoints = Endpoints.fromJson(reader);
                } else if ("primaryLocation".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.primaryLocation = reader.getString();
                } else if ("statusOfPrimary".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.statusOfPrimary
                        = AccountStatus.fromString(reader.getString());
                } else if ("lastGeoFailoverTime".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.lastGeoFailoverTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("secondaryLocation".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.secondaryLocation = reader.getString();
                } else if ("statusOfSecondary".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.statusOfSecondary
                        = AccountStatus.fromString(reader.getString());
                } else if ("creationTime".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.creationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("customDomain".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.customDomain = CustomDomain.fromJson(reader);
                } else if ("sasPolicy".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.sasPolicy = SasPolicy.fromJson(reader);
                } else if ("keyPolicy".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.keyPolicy = KeyPolicy.fromJson(reader);
                } else if ("keyCreationTime".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.keyCreationTime = KeyCreationTime.fromJson(reader);
                } else if ("secondaryEndpoints".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.secondaryEndpoints = Endpoints.fromJson(reader);
                } else if ("encryption".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.encryption = Encryption.fromJson(reader);
                } else if ("accessTier".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.accessTier = AccessTier.fromString(reader.getString());
                } else if ("azureFilesIdentityBasedAuthentication".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.azureFilesIdentityBasedAuthentication
                        = AzureFilesIdentityBasedAuthentication.fromJson(reader);
                } else if ("supportsHttpsTrafficOnly".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.enableHttpsTrafficOnly
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("networkAcls".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.networkRuleSet = NetworkRuleSet.fromJson(reader);
                } else if ("isSftpEnabled".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.isSftpEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("isLocalUserEnabled".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.isLocalUserEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableExtendedGroups".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.enableExtendedGroups
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("isHnsEnabled".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.isHnsEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("geoReplicationStats".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.geoReplicationStats
                        = GeoReplicationStats.fromJson(reader);
                } else if ("failoverInProgress".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.failoverInProgress
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("largeFileSharesState".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.largeFileSharesState
                        = LargeFileSharesState.fromString(reader.getString());
                } else if ("privateEndpointConnections".equals(fieldName)) {
                    List<PrivateEndpointConnectionInner> privateEndpointConnections
                        = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    deserializedStorageAccountPropertiesInner.privateEndpointConnections = privateEndpointConnections;
                } else if ("routingPreference".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.routingPreference = RoutingPreference.fromJson(reader);
                } else if ("dualStackEndpointPreference".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.dualStackEndpointPreference
                        = DualStackEndpointPreference.fromJson(reader);
                } else if ("blobRestoreStatus".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.blobRestoreStatus
                        = BlobRestoreStatusInner.fromJson(reader);
                } else if ("allowBlobPublicAccess".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.allowBlobPublicAccess
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.minimumTlsVersion
                        = MinimumTlsVersion.fromString(reader.getString());
                } else if ("allowSharedKeyAccess".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.allowSharedKeyAccess
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("isNfsV3Enabled".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.enableNfsV3 = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowCrossTenantReplication".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.allowCrossTenantReplication
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("defaultToOAuthAuthentication".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.defaultToOAuthAuthentication
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.publicNetworkAccess
                        = PublicNetworkAccess.fromString(reader.getString());
                } else if ("immutableStorageWithVersioning".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.immutableStorageWithVersioning
                        = ImmutableStorageAccount.fromJson(reader);
                } else if ("allowedCopyScope".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.allowedCopyScope
                        = AllowedCopyScope.fromString(reader.getString());
                } else if ("storageAccountSkuConversionStatus".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.storageAccountSkuConversionStatus
                        = StorageAccountSkuConversionStatus.fromJson(reader);
                } else if ("dnsEndpointType".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.dnsEndpointType
                        = DnsEndpointType.fromString(reader.getString());
                } else if ("isSkuConversionBlocked".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.isSkuConversionBlocked
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("accountMigrationInProgress".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.accountMigrationInProgress
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("geoPriorityReplicationStatus".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.geoPriorityReplicationStatus
                        = GeoPriorityReplicationStatus.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageAccountPropertiesInner;
        });
    }
}
