// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.storage.fluent.models.StorageTaskAssignmentInner;
import com.azure.resourcemanager.storage.models.StorageTaskAssignmentUpdateParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in StorageTaskAssignmentsClient.
 */
public interface StorageTaskAssignmentsClient {
    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentInner parameters);

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginCreateAsync(
        String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentInner parameters);

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginCreate(String resourceGroupName,
        String accountName, String storageTaskAssignmentName, StorageTaskAssignmentInner parameters);

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginCreate(String resourceGroupName,
        String accountName, String storageTaskAssignmentName, StorageTaskAssignmentInner parameters, Context context);

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StorageTaskAssignmentInner> createAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentInner parameters);

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageTaskAssignmentInner create(String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentInner parameters);

    /**
     * Asynchronously creates a new storage task assignment sub-resource with the specified parameters. If a storage
     * task assignment is already created and a subsequent create request is issued with different properties, the
     * storage task assignment properties will be updated. If a storage task assignment is already created and a
     * subsequent create or update request is issued with the exact same set of properties, the request will succeed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to create a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageTaskAssignmentInner create(String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentInner parameters, Context context);

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentUpdateParameters parameters);

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginUpdateAsync(
        String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentUpdateParameters parameters);

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginUpdate(String resourceGroupName,
        String accountName, String storageTaskAssignmentName, StorageTaskAssignmentUpdateParameters parameters);

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<StorageTaskAssignmentInner>, StorageTaskAssignmentInner> beginUpdate(String resourceGroupName,
        String accountName, String storageTaskAssignmentName, StorageTaskAssignmentUpdateParameters parameters,
        Context context);

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StorageTaskAssignmentInner> updateAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, StorageTaskAssignmentUpdateParameters parameters);

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageTaskAssignmentInner update(String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentUpdateParameters parameters);

    /**
     * Update storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param parameters The parameters to update a Storage Task Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageTaskAssignmentInner update(String resourceGroupName, String accountName, String storageTaskAssignmentName,
        StorageTaskAssignmentUpdateParameters parameters, Context context);

    /**
     * Get the storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment properties along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StorageTaskAssignmentInner>> getWithResponseAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName);

    /**
     * Get the storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment properties on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StorageTaskAssignmentInner> getAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName);

    /**
     * Get the storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment properties along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StorageTaskAssignmentInner> getWithResponse(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, Context context);

    /**
     * Get the storage task assignment properties.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage task assignment properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageTaskAssignmentInner get(String resourceGroupName, String accountName, String storageTaskAssignmentName);

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName);

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String accountName,
        String storageTaskAssignmentName);

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName,
        String storageTaskAssignmentName);

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName,
        String storageTaskAssignmentName, Context context);

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String accountName, String storageTaskAssignmentName);

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String accountName, String storageTaskAssignmentName);

    /**
     * Delete the storage task assignment sub-resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group.
     * Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case
     * letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String accountName, String storageTaskAssignmentName, Context context);

    /**
     * List all the storage task assignments in an account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param top Optional, specifies the maximum number of storage task assignment Ids to be included in the list
     * response.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StorageTaskAssignmentInner> listAsync(String resourceGroupName, String accountName, Integer top);

    /**
     * List all the storage task assignments in an account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StorageTaskAssignmentInner> listAsync(String resourceGroupName, String accountName);

    /**
     * List all the storage task assignments in an account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StorageTaskAssignmentInner> list(String resourceGroupName, String accountName);

    /**
     * List all the storage task assignments in an account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param top Optional, specifies the maximum number of storage task assignment Ids to be included in the list
     * response.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of storage task assignments for the storage account as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StorageTaskAssignmentInner> list(String resourceGroupName, String accountName, Integer top,
        Context context);
}
