// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Optional. The object replication policy metrics feature options.
 */
@Fluent
public final class ObjectReplicationPolicyPropertiesMetrics
    implements JsonSerializable<ObjectReplicationPolicyPropertiesMetrics> {
    /*
     * Indicates whether object replication metrics feature is enabled for the policy.
     */
    private Boolean enabled;

    /**
     * Creates an instance of ObjectReplicationPolicyPropertiesMetrics class.
     */
    public ObjectReplicationPolicyPropertiesMetrics() {
    }

    /**
     * Get the enabled property: Indicates whether object replication metrics feature is enabled for the policy.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether object replication metrics feature is enabled for the policy.
     * 
     * @param enabled the enabled value to set.
     * @return the ObjectReplicationPolicyPropertiesMetrics object itself.
     */
    public ObjectReplicationPolicyPropertiesMetrics withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ObjectReplicationPolicyPropertiesMetrics from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ObjectReplicationPolicyPropertiesMetrics if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ObjectReplicationPolicyPropertiesMetrics.
     */
    public static ObjectReplicationPolicyPropertiesMetrics fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ObjectReplicationPolicyPropertiesMetrics deserializedObjectReplicationPolicyPropertiesMetrics
                = new ObjectReplicationPolicyPropertiesMetrics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedObjectReplicationPolicyPropertiesMetrics.enabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedObjectReplicationPolicyPropertiesMetrics;
        });
    }
}
