// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Setting for NFS protocol.
 */
@Fluent
public final class NfsSetting implements JsonSerializable<NfsSetting> {
    /*
     * Encryption in transit setting.
     */
    private EncryptionInTransit encryptionInTransit;

    /**
     * Creates an instance of NfsSetting class.
     */
    public NfsSetting() {
    }

    /**
     * Get the encryptionInTransit property: Encryption in transit setting.
     * 
     * @return the encryptionInTransit value.
     */
    public EncryptionInTransit encryptionInTransit() {
        return this.encryptionInTransit;
    }

    /**
     * Set the encryptionInTransit property: Encryption in transit setting.
     * 
     * @param encryptionInTransit the encryptionInTransit value to set.
     * @return the NfsSetting object itself.
     */
    public NfsSetting withEncryptionInTransit(EncryptionInTransit encryptionInTransit) {
        this.encryptionInTransit = encryptionInTransit;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (encryptionInTransit() != null) {
            encryptionInTransit().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("encryptionInTransit", this.encryptionInTransit);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NfsSetting from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NfsSetting if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the NfsSetting.
     */
    public static NfsSetting fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NfsSetting deserializedNfsSetting = new NfsSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("encryptionInTransit".equals(fieldName)) {
                    deserializedNfsSetting.encryptionInTransit = EncryptionInTransit.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNfsSetting;
        });
    }
}
