// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Geo Priority Replication enablement status for the storage account.
 */
@Fluent
public final class GeoPriorityReplicationStatus implements JsonSerializable<GeoPriorityReplicationStatus> {
    /*
     * Indicates whether Blob Geo Priority Replication is enabled for the storage account.
     */
    private Boolean isBlobEnabled;

    /**
     * Creates an instance of GeoPriorityReplicationStatus class.
     */
    public GeoPriorityReplicationStatus() {
    }

    /**
     * Get the isBlobEnabled property: Indicates whether Blob Geo Priority Replication is enabled for the storage
     * account.
     * 
     * @return the isBlobEnabled value.
     */
    public Boolean isBlobEnabled() {
        return this.isBlobEnabled;
    }

    /**
     * Set the isBlobEnabled property: Indicates whether Blob Geo Priority Replication is enabled for the storage
     * account.
     * 
     * @param isBlobEnabled the isBlobEnabled value to set.
     * @return the GeoPriorityReplicationStatus object itself.
     */
    public GeoPriorityReplicationStatus withIsBlobEnabled(Boolean isBlobEnabled) {
        this.isBlobEnabled = isBlobEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isBlobEnabled", this.isBlobEnabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GeoPriorityReplicationStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GeoPriorityReplicationStatus if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GeoPriorityReplicationStatus.
     */
    public static GeoPriorityReplicationStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GeoPriorityReplicationStatus deserializedGeoPriorityReplicationStatus = new GeoPriorityReplicationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isBlobEnabled".equals(fieldName)) {
                    deserializedGeoPriorityReplicationStatus.isBlobEnabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGeoPriorityReplicationStatus;
        });
    }
}
