// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Encryption in transit setting.
 */
@Fluent
public final class EncryptionInTransit implements JsonSerializable<EncryptionInTransit> {
    /*
     * Indicates whether encryption in transit is required
     */
    private Boolean required;

    /**
     * Creates an instance of EncryptionInTransit class.
     */
    public EncryptionInTransit() {
    }

    /**
     * Get the required property: Indicates whether encryption in transit is required.
     * 
     * @return the required value.
     */
    public Boolean required() {
        return this.required;
    }

    /**
     * Set the required property: Indicates whether encryption in transit is required.
     * 
     * @param required the required value to set.
     * @return the EncryptionInTransit object itself.
     */
    public EncryptionInTransit withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("required", this.required);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncryptionInTransit from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncryptionInTransit if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EncryptionInTransit.
     */
    public static EncryptionInTransit fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionInTransit deserializedEncryptionInTransit = new EncryptionInTransit();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("required".equals(fieldName)) {
                    deserializedEncryptionInTransit.required = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryptionInTransit;
        });
    }
}
