// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Constants used for calculating included burst IOPS and maximum burst credits for IOPS for a file share in the storage
 * account.
 */
@Immutable
public final class BurstingConstants implements JsonSerializable<BurstingConstants> {
    /*
     * The guaranteed floor of burst IOPS for small file shares.
     */
    private Integer burstFloorIops;

    /*
     * The scalar against provisioned IOPS in the file share included burst IOPS formula.
     */
    private Double burstIOScalar;

    /*
     * The time frame for bursting in seconds in the file share maximum burst credits for IOPS formula.
     */
    private Integer burstTimeframeSeconds;

    /**
     * Creates an instance of BurstingConstants class.
     */
    public BurstingConstants() {
    }

    /**
     * Get the burstFloorIops property: The guaranteed floor of burst IOPS for small file shares.
     * 
     * @return the burstFloorIops value.
     */
    public Integer burstFloorIops() {
        return this.burstFloorIops;
    }

    /**
     * Get the burstIOScalar property: The scalar against provisioned IOPS in the file share included burst IOPS
     * formula.
     * 
     * @return the burstIOScalar value.
     */
    public Double burstIOScalar() {
        return this.burstIOScalar;
    }

    /**
     * Get the burstTimeframeSeconds property: The time frame for bursting in seconds in the file share maximum burst
     * credits for IOPS formula.
     * 
     * @return the burstTimeframeSeconds value.
     */
    public Integer burstTimeframeSeconds() {
        return this.burstTimeframeSeconds;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BurstingConstants from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BurstingConstants if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BurstingConstants.
     */
    public static BurstingConstants fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BurstingConstants deserializedBurstingConstants = new BurstingConstants();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("burstFloorIOPS".equals(fieldName)) {
                    deserializedBurstingConstants.burstFloorIops = reader.getNullable(JsonReader::getInt);
                } else if ("burstIOScalar".equals(fieldName)) {
                    deserializedBurstingConstants.burstIOScalar = reader.getNullable(JsonReader::getDouble);
                } else if ("burstTimeframeSeconds".equals(fieldName)) {
                    deserializedBurstingConstants.burstTimeframeSeconds = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBurstingConstants;
        });
    }
}
