// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.StorageTaskAssignmentProperties;
import java.io.IOException;

/**
 * The storage task assignment.
 */
@Fluent
public final class StorageTaskAssignmentInner extends ProxyResource {
    /*
     * Properties of the storage task assignment.
     */
    private StorageTaskAssignmentProperties properties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of StorageTaskAssignmentInner class.
     */
    public StorageTaskAssignmentInner() {
    }

    /**
     * Get the properties property: Properties of the storage task assignment.
     * 
     * @return the properties value.
     */
    public StorageTaskAssignmentProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the storage task assignment.
     * 
     * @param properties the properties value to set.
     * @return the StorageTaskAssignmentInner object itself.
     */
    public StorageTaskAssignmentInner withProperties(StorageTaskAssignmentProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property properties in model StorageTaskAssignmentInner"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskAssignmentInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageTaskAssignmentInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageTaskAssignmentInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StorageTaskAssignmentInner.
     */
    public static StorageTaskAssignmentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageTaskAssignmentInner deserializedStorageTaskAssignmentInner = new StorageTaskAssignmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStorageTaskAssignmentInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStorageTaskAssignmentInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStorageTaskAssignmentInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedStorageTaskAssignmentInner.properties
                        = StorageTaskAssignmentProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageTaskAssignmentInner;
        });
    }
}
