/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountPropertiesUpdateParameters;
import com.azure.resourcemanager.storage.models.AccessTier;
import com.azure.resourcemanager.storage.models.AllowedCopyScope;
import com.azure.resourcemanager.storage.models.AzureFilesIdentityBasedAuthentication;
import com.azure.resourcemanager.storage.models.CustomDomain;
import com.azure.resourcemanager.storage.models.DnsEndpointType;
import com.azure.resourcemanager.storage.models.DualStackEndpointPreference;
import com.azure.resourcemanager.storage.models.Encryption;
import com.azure.resourcemanager.storage.models.Identity;
import com.azure.resourcemanager.storage.models.ImmutableStorageAccount;
import com.azure.resourcemanager.storage.models.KeyPolicy;
import com.azure.resourcemanager.storage.models.Kind;
import com.azure.resourcemanager.storage.models.LargeFileSharesState;
import com.azure.resourcemanager.storage.models.MinimumTlsVersion;
import com.azure.resourcemanager.storage.models.NetworkRuleSet;
import com.azure.resourcemanager.storage.models.Placement;
import com.azure.resourcemanager.storage.models.PublicNetworkAccess;
import com.azure.resourcemanager.storage.models.RoutingPreference;
import com.azure.resourcemanager.storage.models.SasPolicy;
import com.azure.resourcemanager.storage.models.Sku;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class StorageAccountUpdateParameters
implements JsonSerializable<StorageAccountUpdateParameters> {
    private Sku sku;
    private Map<String, String> tags;
    private Identity identity;
    private StorageAccountPropertiesUpdateParameters innerProperties;
    private Kind kind;
    private List<String> zones;
    private Placement placement;

    public Sku sku() {
        return this.sku;
    }

    public StorageAccountUpdateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public StorageAccountUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public StorageAccountUpdateParameters withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    private StorageAccountPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public Kind kind() {
        return this.kind;
    }

    public StorageAccountUpdateParameters withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public StorageAccountUpdateParameters withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public Placement placement() {
        return this.placement;
    }

    public StorageAccountUpdateParameters withPlacement(Placement placement) {
        this.placement = placement;
        return this;
    }

    public CustomDomain customDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomain();
    }

    public StorageAccountUpdateParameters withCustomDomain(CustomDomain customDomain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withCustomDomain(customDomain);
        return this;
    }

    public Encryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public StorageAccountUpdateParameters withEncryption(Encryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public SasPolicy sasPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().sasPolicy();
    }

    public StorageAccountUpdateParameters withSasPolicy(SasPolicy sasPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withSasPolicy(sasPolicy);
        return this;
    }

    public KeyPolicy keyPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().keyPolicy();
    }

    public StorageAccountUpdateParameters withKeyPolicy(KeyPolicy keyPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withKeyPolicy(keyPolicy);
        return this;
    }

    public AccessTier accessTier() {
        return this.innerProperties() == null ? null : this.innerProperties().accessTier();
    }

    public StorageAccountUpdateParameters withAccessTier(AccessTier accessTier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withAccessTier(accessTier);
        return this;
    }

    public AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().azureFilesIdentityBasedAuthentication();
    }

    public StorageAccountUpdateParameters withAzureFilesIdentityBasedAuthentication(AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withAzureFilesIdentityBasedAuthentication(azureFilesIdentityBasedAuthentication);
        return this;
    }

    public Boolean enableHttpsTrafficOnly() {
        return this.innerProperties() == null ? null : this.innerProperties().enableHttpsTrafficOnly();
    }

    public StorageAccountUpdateParameters withEnableHttpsTrafficOnly(Boolean enableHttpsTrafficOnly) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withEnableHttpsTrafficOnly(enableHttpsTrafficOnly);
        return this;
    }

    public Boolean isSftpEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isSftpEnabled();
    }

    public StorageAccountUpdateParameters withIsSftpEnabled(Boolean isSftpEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withIsSftpEnabled(isSftpEnabled);
        return this;
    }

    public Boolean isLocalUserEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isLocalUserEnabled();
    }

    public StorageAccountUpdateParameters withIsLocalUserEnabled(Boolean isLocalUserEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withIsLocalUserEnabled(isLocalUserEnabled);
        return this;
    }

    public Boolean enableExtendedGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().enableExtendedGroups();
    }

    public StorageAccountUpdateParameters withEnableExtendedGroups(Boolean enableExtendedGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withEnableExtendedGroups(enableExtendedGroups);
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleSet();
    }

    public StorageAccountUpdateParameters withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withNetworkRuleSet(networkRuleSet);
        return this;
    }

    public LargeFileSharesState largeFileSharesState() {
        return this.innerProperties() == null ? null : this.innerProperties().largeFileSharesState();
    }

    public StorageAccountUpdateParameters withLargeFileSharesState(LargeFileSharesState largeFileSharesState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withLargeFileSharesState(largeFileSharesState);
        return this;
    }

    public RoutingPreference routingPreference() {
        return this.innerProperties() == null ? null : this.innerProperties().routingPreference();
    }

    public StorageAccountUpdateParameters withRoutingPreference(RoutingPreference routingPreference) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withRoutingPreference(routingPreference);
        return this;
    }

    public DualStackEndpointPreference dualStackEndpointPreference() {
        return this.innerProperties() == null ? null : this.innerProperties().dualStackEndpointPreference();
    }

    public StorageAccountUpdateParameters withDualStackEndpointPreference(DualStackEndpointPreference dualStackEndpointPreference) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withDualStackEndpointPreference(dualStackEndpointPreference);
        return this;
    }

    public Boolean allowBlobPublicAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().allowBlobPublicAccess();
    }

    public StorageAccountUpdateParameters withAllowBlobPublicAccess(Boolean allowBlobPublicAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withAllowBlobPublicAccess(allowBlobPublicAccess);
        return this;
    }

    public MinimumTlsVersion minimumTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersion();
    }

    public StorageAccountUpdateParameters withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    public Boolean allowSharedKeyAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().allowSharedKeyAccess();
    }

    public StorageAccountUpdateParameters withAllowSharedKeyAccess(Boolean allowSharedKeyAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withAllowSharedKeyAccess(allowSharedKeyAccess);
        return this;
    }

    public Boolean allowCrossTenantReplication() {
        return this.innerProperties() == null ? null : this.innerProperties().allowCrossTenantReplication();
    }

    public StorageAccountUpdateParameters withAllowCrossTenantReplication(Boolean allowCrossTenantReplication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withAllowCrossTenantReplication(allowCrossTenantReplication);
        return this;
    }

    public Boolean defaultToOAuthAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultToOAuthAuthentication();
    }

    public StorageAccountUpdateParameters withDefaultToOAuthAuthentication(Boolean defaultToOAuthAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withDefaultToOAuthAuthentication(defaultToOAuthAuthentication);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public StorageAccountUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public ImmutableStorageAccount immutableStorageWithVersioning() {
        return this.innerProperties() == null ? null : this.innerProperties().immutableStorageWithVersioning();
    }

    public StorageAccountUpdateParameters withImmutableStorageWithVersioning(ImmutableStorageAccount immutableStorageWithVersioning) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withImmutableStorageWithVersioning(immutableStorageWithVersioning);
        return this;
    }

    public AllowedCopyScope allowedCopyScope() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedCopyScope();
    }

    public StorageAccountUpdateParameters withAllowedCopyScope(AllowedCopyScope allowedCopyScope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withAllowedCopyScope(allowedCopyScope);
        return this;
    }

    public DnsEndpointType dnsEndpointType() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsEndpointType();
    }

    public StorageAccountUpdateParameters withDnsEndpointType(DnsEndpointType dnsEndpointType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesUpdateParameters();
        }
        this.innerProperties().withDnsEndpointType(dnsEndpointType);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.placement() != null) {
            this.placement().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("placement", (JsonSerializable)this.placement);
        return jsonWriter.writeEndObject();
    }

    public static StorageAccountUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (StorageAccountUpdateParameters)jsonReader.readObject(reader -> {
            StorageAccountUpdateParameters deserializedStorageAccountUpdateParameters = new StorageAccountUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedStorageAccountUpdateParameters.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedStorageAccountUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedStorageAccountUpdateParameters.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStorageAccountUpdateParameters.innerProperties = StorageAccountPropertiesUpdateParameters.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedStorageAccountUpdateParameters.kind = Kind.fromString(reader.getString());
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedStorageAccountUpdateParameters.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("placement".equals(fieldName)) {
                    deserializedStorageAccountUpdateParameters.placement = Placement.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccountUpdateParameters;
        });
    }
}

