// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object via an IPv6 endpoint.
 */
@Fluent
public final class StorageAccountIpv6Endpoints implements JsonSerializable<StorageAccountIpv6Endpoints> {
    /*
     * Gets the blob endpoint.
     */
    private String blob;

    /*
     * Gets the queue endpoint.
     */
    private String queue;

    /*
     * Gets the table endpoint.
     */
    private String table;

    /*
     * Gets the file endpoint.
     */
    private String file;

    /*
     * Gets the web endpoint.
     */
    private String web;

    /*
     * Gets the dfs endpoint.
     */
    private String dfs;

    /*
     * Gets the microsoft routing storage endpoints.
     */
    private StorageAccountMicrosoftEndpoints microsoftEndpoints;

    /*
     * Gets the internet routing storage endpoints
     */
    private StorageAccountInternetEndpoints internetEndpoints;

    /**
     * Creates an instance of StorageAccountIpv6Endpoints class.
     */
    public StorageAccountIpv6Endpoints() {
    }

    /**
     * Get the blob property: Gets the blob endpoint.
     * 
     * @return the blob value.
     */
    public String blob() {
        return this.blob;
    }

    /**
     * Get the queue property: Gets the queue endpoint.
     * 
     * @return the queue value.
     */
    public String queue() {
        return this.queue;
    }

    /**
     * Get the table property: Gets the table endpoint.
     * 
     * @return the table value.
     */
    public String table() {
        return this.table;
    }

    /**
     * Get the file property: Gets the file endpoint.
     * 
     * @return the file value.
     */
    public String file() {
        return this.file;
    }

    /**
     * Get the web property: Gets the web endpoint.
     * 
     * @return the web value.
     */
    public String web() {
        return this.web;
    }

    /**
     * Get the dfs property: Gets the dfs endpoint.
     * 
     * @return the dfs value.
     */
    public String dfs() {
        return this.dfs;
    }

    /**
     * Get the microsoftEndpoints property: Gets the microsoft routing storage endpoints.
     * 
     * @return the microsoftEndpoints value.
     */
    public StorageAccountMicrosoftEndpoints microsoftEndpoints() {
        return this.microsoftEndpoints;
    }

    /**
     * Set the microsoftEndpoints property: Gets the microsoft routing storage endpoints.
     * 
     * @param microsoftEndpoints the microsoftEndpoints value to set.
     * @return the StorageAccountIpv6Endpoints object itself.
     */
    public StorageAccountIpv6Endpoints withMicrosoftEndpoints(StorageAccountMicrosoftEndpoints microsoftEndpoints) {
        this.microsoftEndpoints = microsoftEndpoints;
        return this;
    }

    /**
     * Get the internetEndpoints property: Gets the internet routing storage endpoints.
     * 
     * @return the internetEndpoints value.
     */
    public StorageAccountInternetEndpoints internetEndpoints() {
        return this.internetEndpoints;
    }

    /**
     * Set the internetEndpoints property: Gets the internet routing storage endpoints.
     * 
     * @param internetEndpoints the internetEndpoints value to set.
     * @return the StorageAccountIpv6Endpoints object itself.
     */
    public StorageAccountIpv6Endpoints withInternetEndpoints(StorageAccountInternetEndpoints internetEndpoints) {
        this.internetEndpoints = internetEndpoints;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (microsoftEndpoints() != null) {
            microsoftEndpoints().validate();
        }
        if (internetEndpoints() != null) {
            internetEndpoints().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("microsoftEndpoints", this.microsoftEndpoints);
        jsonWriter.writeJsonField("internetEndpoints", this.internetEndpoints);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageAccountIpv6Endpoints from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageAccountIpv6Endpoints if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageAccountIpv6Endpoints.
     */
    public static StorageAccountIpv6Endpoints fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageAccountIpv6Endpoints deserializedStorageAccountIpv6Endpoints = new StorageAccountIpv6Endpoints();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("blob".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.blob = reader.getString();
                } else if ("queue".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.queue = reader.getString();
                } else if ("table".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.table = reader.getString();
                } else if ("file".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.file = reader.getString();
                } else if ("web".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.web = reader.getString();
                } else if ("dfs".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.dfs = reader.getString();
                } else if ("microsoftEndpoints".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.microsoftEndpoints
                        = StorageAccountMicrosoftEndpoints.fromJson(reader);
                } else if ("internetEndpoints".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.internetEndpoints
                        = StorageAccountInternetEndpoints.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageAccountIpv6Endpoints;
        });
    }
}
