// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Setting property for Managed Identity access over SMB using OAuth.
 */
@Fluent
public final class SmbOAuthSettings implements JsonSerializable<SmbOAuthSettings> {
    /*
     * Specifies if managed identities can access SMB shares using OAuth. The default interpretation is false for this
     * property.
     */
    private Boolean isSmbOAuthEnabled;

    /**
     * Creates an instance of SmbOAuthSettings class.
     */
    public SmbOAuthSettings() {
    }

    /**
     * Get the isSmbOAuthEnabled property: Specifies if managed identities can access SMB shares using OAuth. The
     * default interpretation is false for this property.
     * 
     * @return the isSmbOAuthEnabled value.
     */
    public Boolean isSmbOAuthEnabled() {
        return this.isSmbOAuthEnabled;
    }

    /**
     * Set the isSmbOAuthEnabled property: Specifies if managed identities can access SMB shares using OAuth. The
     * default interpretation is false for this property.
     * 
     * @param isSmbOAuthEnabled the isSmbOAuthEnabled value to set.
     * @return the SmbOAuthSettings object itself.
     */
    public SmbOAuthSettings withIsSmbOAuthEnabled(Boolean isSmbOAuthEnabled) {
        this.isSmbOAuthEnabled = isSmbOAuthEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isSmbOAuthEnabled", this.isSmbOAuthEnabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SmbOAuthSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SmbOAuthSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SmbOAuthSettings.
     */
    public static SmbOAuthSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SmbOAuthSettings deserializedSmbOAuthSettings = new SmbOAuthSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isSmbOAuthEnabled".equals(fieldName)) {
                    deserializedSmbOAuthSettings.isSmbOAuthEnabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSmbOAuthSettings;
        });
    }
}
