// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is
 * set to 'Microsoft.KeyVault'.
 */
@Fluent
public final class EncryptionScopeKeyVaultProperties implements JsonSerializable<EncryptionScopeKeyVaultProperties> {
    /*
     * The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced
     * by the identifier to enable customer-managed key support on this encryption scope.
     */
    private String keyUri;

    /*
     * The object identifier of the current versioned Key Vault Key in use.
     */
    private String currentVersionedKeyIdentifier;

    /*
     * Timestamp of last rotation of the Key Vault Key.
     */
    private OffsetDateTime lastKeyRotationTimestamp;

    /**
     * Creates an instance of EncryptionScopeKeyVaultProperties class.
     */
    public EncryptionScopeKeyVaultProperties() {
    }

    /**
     * Get the keyUri property: The object identifier for a key vault key object. When applied, the encryption scope
     * will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
     * 
     * @return the keyUri value.
     */
    public String keyUri() {
        return this.keyUri;
    }

    /**
     * Set the keyUri property: The object identifier for a key vault key object. When applied, the encryption scope
     * will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
     * 
     * @param keyUri the keyUri value to set.
     * @return the EncryptionScopeKeyVaultProperties object itself.
     */
    public EncryptionScopeKeyVaultProperties withKeyUri(String keyUri) {
        this.keyUri = keyUri;
        return this;
    }

    /**
     * Get the currentVersionedKeyIdentifier property: The object identifier of the current versioned Key Vault Key in
     * use.
     * 
     * @return the currentVersionedKeyIdentifier value.
     */
    public String currentVersionedKeyIdentifier() {
        return this.currentVersionedKeyIdentifier;
    }

    /**
     * Get the lastKeyRotationTimestamp property: Timestamp of last rotation of the Key Vault Key.
     * 
     * @return the lastKeyRotationTimestamp value.
     */
    public OffsetDateTime lastKeyRotationTimestamp() {
        return this.lastKeyRotationTimestamp;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyUri", this.keyUri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncryptionScopeKeyVaultProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncryptionScopeKeyVaultProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EncryptionScopeKeyVaultProperties.
     */
    public static EncryptionScopeKeyVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionScopeKeyVaultProperties deserializedEncryptionScopeKeyVaultProperties
                = new EncryptionScopeKeyVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyUri".equals(fieldName)) {
                    deserializedEncryptionScopeKeyVaultProperties.keyUri = reader.getString();
                } else if ("currentVersionedKeyIdentifier".equals(fieldName)) {
                    deserializedEncryptionScopeKeyVaultProperties.currentVersionedKeyIdentifier = reader.getString();
                } else if ("lastKeyRotationTimestamp".equals(fieldName)) {
                    deserializedEncryptionScopeKeyVaultProperties.lastKeyRotationTimestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryptionScopeKeyVaultProperties;
        });
    }
}
