// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Dual-stack endpoint preference defines whether IPv6 endpoints are going to be published.
 */
@Fluent
public final class DualStackEndpointPreference implements JsonSerializable<DualStackEndpointPreference> {
    /*
     * A boolean flag which indicates whether IPv6 storage endpoints are to be published.
     */
    private Boolean publishIpv6Endpoint;

    /**
     * Creates an instance of DualStackEndpointPreference class.
     */
    public DualStackEndpointPreference() {
    }

    /**
     * Get the publishIpv6Endpoint property: A boolean flag which indicates whether IPv6 storage endpoints are to be
     * published.
     * 
     * @return the publishIpv6Endpoint value.
     */
    public Boolean publishIpv6Endpoint() {
        return this.publishIpv6Endpoint;
    }

    /**
     * Set the publishIpv6Endpoint property: A boolean flag which indicates whether IPv6 storage endpoints are to be
     * published.
     * 
     * @param publishIpv6Endpoint the publishIpv6Endpoint value to set.
     * @return the DualStackEndpointPreference object itself.
     */
    public DualStackEndpointPreference withPublishIpv6Endpoint(Boolean publishIpv6Endpoint) {
        this.publishIpv6Endpoint = publishIpv6Endpoint;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("publishIpv6Endpoint", this.publishIpv6Endpoint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DualStackEndpointPreference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DualStackEndpointPreference if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DualStackEndpointPreference.
     */
    public static DualStackEndpointPreference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DualStackEndpointPreference deserializedDualStackEndpointPreference = new DualStackEndpointPreference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("publishIpv6Endpoint".equals(fieldName)) {
                    deserializedDualStackEndpointPreference.publishIpv6Endpoint
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDualStackEndpointPreference;
        });
    }
}
