// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The service properties for soft delete.
 */
@Fluent
public final class DeleteRetentionPolicy implements JsonSerializable<DeleteRetentionPolicy> {
    /*
     * Indicates whether DeleteRetentionPolicy is enabled.
     */
    private Boolean enabled;

    /*
     * Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and
     * the maximum value can be 365.
     */
    private Integer days;

    /*
     * This property when set to true allows deletion of the soft deleted blob versions and snapshots. This property
     * cannot be used blob restore policy. This property only applies to blob service and does not apply to containers
     * or file share.
     */
    private Boolean allowPermanentDelete;

    /**
     * Creates an instance of DeleteRetentionPolicy class.
     */
    public DeleteRetentionPolicy() {
    }

    /**
     * Get the enabled property: Indicates whether DeleteRetentionPolicy is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether DeleteRetentionPolicy is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the DeleteRetentionPolicy object itself.
     */
    public DeleteRetentionPolicy withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the days property: Indicates the number of days that the deleted item should be retained. The minimum
     * specified value can be 1 and the maximum value can be 365.
     * 
     * @return the days value.
     */
    public Integer days() {
        return this.days;
    }

    /**
     * Set the days property: Indicates the number of days that the deleted item should be retained. The minimum
     * specified value can be 1 and the maximum value can be 365.
     * 
     * @param days the days value to set.
     * @return the DeleteRetentionPolicy object itself.
     */
    public DeleteRetentionPolicy withDays(Integer days) {
        this.days = days;
        return this;
    }

    /**
     * Get the allowPermanentDelete property: This property when set to true allows deletion of the soft deleted blob
     * versions and snapshots. This property cannot be used blob restore policy. This property only applies to blob
     * service and does not apply to containers or file share.
     * 
     * @return the allowPermanentDelete value.
     */
    public Boolean allowPermanentDelete() {
        return this.allowPermanentDelete;
    }

    /**
     * Set the allowPermanentDelete property: This property when set to true allows deletion of the soft deleted blob
     * versions and snapshots. This property cannot be used blob restore policy. This property only applies to blob
     * service and does not apply to containers or file share.
     * 
     * @param allowPermanentDelete the allowPermanentDelete value to set.
     * @return the DeleteRetentionPolicy object itself.
     */
    public DeleteRetentionPolicy withAllowPermanentDelete(Boolean allowPermanentDelete) {
        this.allowPermanentDelete = allowPermanentDelete;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("days", this.days);
        jsonWriter.writeBooleanField("allowPermanentDelete", this.allowPermanentDelete);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeleteRetentionPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeleteRetentionPolicy if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeleteRetentionPolicy.
     */
    public static DeleteRetentionPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeleteRetentionPolicy deserializedDeleteRetentionPolicy = new DeleteRetentionPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedDeleteRetentionPolicy.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("days".equals(fieldName)) {
                    deserializedDeleteRetentionPolicy.days = reader.getNullable(JsonReader::getInt);
                } else if ("allowPermanentDelete".equals(fieldName)) {
                    deserializedDeleteRetentionPolicy.allowPermanentDelete = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeleteRetentionPolicy;
        });
    }
}
