// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.PermissionScope;
import com.azure.resourcemanager.storage.models.SshPublicKey;
import java.io.IOException;
import java.util.List;

/**
 * The Storage Account Local User properties.
 */
@Fluent
public final class LocalUserProperties implements JsonSerializable<LocalUserProperties> {
    /*
     * The permission scopes of the local user.
     */
    private List<PermissionScope> permissionScopes;

    /*
     * Optional, local user home directory.
     */
    private String homeDirectory;

    /*
     * Optional, local user ssh authorized keys for SFTP.
     */
    private List<SshPublicKey> sshAuthorizedKeys;

    /*
     * A unique Security Identifier that is generated by the server.
     */
    private String sid;

    /*
     * Indicates whether shared key exists. Set it to false to remove existing shared key.
     */
    private Boolean hasSharedKey;

    /*
     * Indicates whether ssh key exists. Set it to false to remove existing SSH key.
     */
    private Boolean hasSshKey;

    /*
     * Indicates whether ssh password exists. Set it to false to remove existing SSH password.
     */
    private Boolean hasSshPassword;

    /*
     * A unique Identifier that is generated by the server.
     */
    private Integer userId;

    /*
     * An identifier for associating a group of users.
     */
    private Integer groupId;

    /*
     * Indicates whether ACL authorization is allowed for this user. Set it to false to disallow using ACL
     * authorization.
     */
    private Boolean allowAclAuthorization;

    /*
     * Supplementary group membership. Only applicable for local users enabled for NFSv3 access.
     */
    private List<Integer> extendedGroups;

    /*
     * Indicates if the local user is enabled for access with NFSv3 protocol.
     */
    private Boolean isNFSv3Enabled;

    /**
     * Creates an instance of LocalUserProperties class.
     */
    public LocalUserProperties() {
    }

    /**
     * Get the permissionScopes property: The permission scopes of the local user.
     * 
     * @return the permissionScopes value.
     */
    public List<PermissionScope> permissionScopes() {
        return this.permissionScopes;
    }

    /**
     * Set the permissionScopes property: The permission scopes of the local user.
     * 
     * @param permissionScopes the permissionScopes value to set.
     * @return the LocalUserProperties object itself.
     */
    public LocalUserProperties withPermissionScopes(List<PermissionScope> permissionScopes) {
        this.permissionScopes = permissionScopes;
        return this;
    }

    /**
     * Get the homeDirectory property: Optional, local user home directory.
     * 
     * @return the homeDirectory value.
     */
    public String homeDirectory() {
        return this.homeDirectory;
    }

    /**
     * Set the homeDirectory property: Optional, local user home directory.
     * 
     * @param homeDirectory the homeDirectory value to set.
     * @return the LocalUserProperties object itself.
     */
    public LocalUserProperties withHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
        return this;
    }

    /**
     * Get the sshAuthorizedKeys property: Optional, local user ssh authorized keys for SFTP.
     * 
     * @return the sshAuthorizedKeys value.
     */
    public List<SshPublicKey> sshAuthorizedKeys() {
        return this.sshAuthorizedKeys;
    }

    /**
     * Set the sshAuthorizedKeys property: Optional, local user ssh authorized keys for SFTP.
     * 
     * @param sshAuthorizedKeys the sshAuthorizedKeys value to set.
     * @return the LocalUserProperties object itself.
     */
    public LocalUserProperties withSshAuthorizedKeys(List<SshPublicKey> sshAuthorizedKeys) {
        this.sshAuthorizedKeys = sshAuthorizedKeys;
        return this;
    }

    /**
     * Get the sid property: A unique Security Identifier that is generated by the server.
     * 
     * @return the sid value.
     */
    public String sid() {
        return this.sid;
    }

    /**
     * Get the hasSharedKey property: Indicates whether shared key exists. Set it to false to remove existing shared
     * key.
     * 
     * @return the hasSharedKey value.
     */
    public Boolean hasSharedKey() {
        return this.hasSharedKey;
    }

    /**
     * Set the hasSharedKey property: Indicates whether shared key exists. Set it to false to remove existing shared
     * key.
     * 
     * @param hasSharedKey the hasSharedKey value to set.
     * @return the LocalUserProperties object itself.
     */
    public LocalUserProperties withHasSharedKey(Boolean hasSharedKey) {
        this.hasSharedKey = hasSharedKey;
        return this;
    }

    /**
     * Get the hasSshKey property: Indicates whether ssh key exists. Set it to false to remove existing SSH key.
     * 
     * @return the hasSshKey value.
     */
    public Boolean hasSshKey() {
        return this.hasSshKey;
    }

    /**
     * Set the hasSshKey property: Indicates whether ssh key exists. Set it to false to remove existing SSH key.
     * 
     * @param hasSshKey the hasSshKey value to set.
     * @return the LocalUserProperties object itself.
     */
    public LocalUserProperties withHasSshKey(Boolean hasSshKey) {
        this.hasSshKey = hasSshKey;
        return this;
    }

    /**
     * Get the hasSshPassword property: Indicates whether ssh password exists. Set it to false to remove existing SSH
     * password.
     * 
     * @return the hasSshPassword value.
     */
    public Boolean hasSshPassword() {
        return this.hasSshPassword;
    }

    /**
     * Set the hasSshPassword property: Indicates whether ssh password exists. Set it to false to remove existing SSH
     * password.
     * 
     * @param hasSshPassword the hasSshPassword value to set.
     * @return the LocalUserProperties object itself.
     */
    public LocalUserProperties withHasSshPassword(Boolean hasSshPassword) {
        this.hasSshPassword = hasSshPassword;
        return this;
    }

    /**
     * Get the userId property: A unique Identifier that is generated by the server.
     * 
     * @return the userId value.
     */
    public Integer userId() {
        return this.userId;
    }

    /**
     * Get the groupId property: An identifier for associating a group of users.
     * 
     * @return the groupId value.
     */
    public Integer groupId() {
        return this.groupId;
    }

    /**
     * Set the groupId property: An identifier for associating a group of users.
     * 
     * @param groupId the groupId value to set.
     * @return the LocalUserProperties object itself.
     */
    public LocalUserProperties withGroupId(Integer groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
     * Get the allowAclAuthorization property: Indicates whether ACL authorization is allowed for this user. Set it to
     * false to disallow using ACL authorization.
     * 
     * @return the allowAclAuthorization value.
     */
    public Boolean allowAclAuthorization() {
        return this.allowAclAuthorization;
    }

    /**
     * Set the allowAclAuthorization property: Indicates whether ACL authorization is allowed for this user. Set it to
     * false to disallow using ACL authorization.
     * 
     * @param allowAclAuthorization the allowAclAuthorization value to set.
     * @return the LocalUserProperties object itself.
     */
    public LocalUserProperties withAllowAclAuthorization(Boolean allowAclAuthorization) {
        this.allowAclAuthorization = allowAclAuthorization;
        return this;
    }

    /**
     * Get the extendedGroups property: Supplementary group membership. Only applicable for local users enabled for
     * NFSv3 access.
     * 
     * @return the extendedGroups value.
     */
    public List<Integer> extendedGroups() {
        return this.extendedGroups;
    }

    /**
     * Set the extendedGroups property: Supplementary group membership. Only applicable for local users enabled for
     * NFSv3 access.
     * 
     * @param extendedGroups the extendedGroups value to set.
     * @return the LocalUserProperties object itself.
     */
    public LocalUserProperties withExtendedGroups(List<Integer> extendedGroups) {
        this.extendedGroups = extendedGroups;
        return this;
    }

    /**
     * Get the isNFSv3Enabled property: Indicates if the local user is enabled for access with NFSv3 protocol.
     * 
     * @return the isNFSv3Enabled value.
     */
    public Boolean isNFSv3Enabled() {
        return this.isNFSv3Enabled;
    }

    /**
     * Set the isNFSv3Enabled property: Indicates if the local user is enabled for access with NFSv3 protocol.
     * 
     * @param isNFSv3Enabled the isNFSv3Enabled value to set.
     * @return the LocalUserProperties object itself.
     */
    public LocalUserProperties withIsNFSv3Enabled(Boolean isNFSv3Enabled) {
        this.isNFSv3Enabled = isNFSv3Enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (permissionScopes() != null) {
            permissionScopes().forEach(e -> e.validate());
        }
        if (sshAuthorizedKeys() != null) {
            sshAuthorizedKeys().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("permissionScopes", this.permissionScopes,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("homeDirectory", this.homeDirectory);
        jsonWriter.writeArrayField("sshAuthorizedKeys", this.sshAuthorizedKeys,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("hasSharedKey", this.hasSharedKey);
        jsonWriter.writeBooleanField("hasSshKey", this.hasSshKey);
        jsonWriter.writeBooleanField("hasSshPassword", this.hasSshPassword);
        jsonWriter.writeNumberField("groupId", this.groupId);
        jsonWriter.writeBooleanField("allowAclAuthorization", this.allowAclAuthorization);
        jsonWriter.writeArrayField("extendedGroups", this.extendedGroups,
            (writer, element) -> writer.writeInt(element));
        jsonWriter.writeBooleanField("isNFSv3Enabled", this.isNFSv3Enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LocalUserProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LocalUserProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LocalUserProperties.
     */
    public static LocalUserProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocalUserProperties deserializedLocalUserProperties = new LocalUserProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("permissionScopes".equals(fieldName)) {
                    List<PermissionScope> permissionScopes
                        = reader.readArray(reader1 -> PermissionScope.fromJson(reader1));
                    deserializedLocalUserProperties.permissionScopes = permissionScopes;
                } else if ("homeDirectory".equals(fieldName)) {
                    deserializedLocalUserProperties.homeDirectory = reader.getString();
                } else if ("sshAuthorizedKeys".equals(fieldName)) {
                    List<SshPublicKey> sshAuthorizedKeys = reader.readArray(reader1 -> SshPublicKey.fromJson(reader1));
                    deserializedLocalUserProperties.sshAuthorizedKeys = sshAuthorizedKeys;
                } else if ("sid".equals(fieldName)) {
                    deserializedLocalUserProperties.sid = reader.getString();
                } else if ("hasSharedKey".equals(fieldName)) {
                    deserializedLocalUserProperties.hasSharedKey = reader.getNullable(JsonReader::getBoolean);
                } else if ("hasSshKey".equals(fieldName)) {
                    deserializedLocalUserProperties.hasSshKey = reader.getNullable(JsonReader::getBoolean);
                } else if ("hasSshPassword".equals(fieldName)) {
                    deserializedLocalUserProperties.hasSshPassword = reader.getNullable(JsonReader::getBoolean);
                } else if ("userId".equals(fieldName)) {
                    deserializedLocalUserProperties.userId = reader.getNullable(JsonReader::getInt);
                } else if ("groupId".equals(fieldName)) {
                    deserializedLocalUserProperties.groupId = reader.getNullable(JsonReader::getInt);
                } else if ("allowAclAuthorization".equals(fieldName)) {
                    deserializedLocalUserProperties.allowAclAuthorization = reader.getNullable(JsonReader::getBoolean);
                } else if ("extendedGroups".equals(fieldName)) {
                    List<Integer> extendedGroups = reader.readArray(reader1 -> reader1.getInt());
                    deserializedLocalUserProperties.extendedGroups = extendedGroups;
                } else if ("isNFSv3Enabled".equals(fieldName)) {
                    deserializedLocalUserProperties.isNFSv3Enabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLocalUserProperties;
        });
    }
}
