// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.
 */
@Fluent
public final class ManagementPolicyRule implements JsonSerializable<ManagementPolicyRule> {
    /*
     * Rule is enabled if set to true.
     */
    private Boolean enabled;

    /*
     * A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be
     * unique within a policy.
     */
    private String name;

    /*
     * The valid value is Lifecycle
     */
    private RuleType type;

    /*
     * An object that defines the Lifecycle rule.
     */
    private ManagementPolicyDefinition definition;

    /**
     * Creates an instance of ManagementPolicyRule class.
     */
    public ManagementPolicyRule() {
    }

    /**
     * Get the enabled property: Rule is enabled if set to true.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Rule is enabled if set to true.
     * 
     * @param enabled the enabled value to set.
     * @return the ManagementPolicyRule object itself.
     */
    public ManagementPolicyRule withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the name property: A rule name can contain any combination of alpha numeric characters. Rule name is
     * case-sensitive. It must be unique within a policy.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: A rule name can contain any combination of alpha numeric characters. Rule name is
     * case-sensitive. It must be unique within a policy.
     * 
     * @param name the name value to set.
     * @return the ManagementPolicyRule object itself.
     */
    public ManagementPolicyRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The valid value is Lifecycle.
     * 
     * @return the type value.
     */
    public RuleType type() {
        return this.type;
    }

    /**
     * Set the type property: The valid value is Lifecycle.
     * 
     * @param type the type value to set.
     * @return the ManagementPolicyRule object itself.
     */
    public ManagementPolicyRule withType(RuleType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the definition property: An object that defines the Lifecycle rule.
     * 
     * @return the definition value.
     */
    public ManagementPolicyDefinition definition() {
        return this.definition;
    }

    /**
     * Set the definition property: An object that defines the Lifecycle rule.
     * 
     * @param definition the definition value to set.
     * @return the ManagementPolicyRule object itself.
     */
    public ManagementPolicyRule withDefinition(ManagementPolicyDefinition definition) {
        this.definition = definition;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model ManagementPolicyRule"));
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model ManagementPolicyRule"));
        }
        if (definition() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property definition in model ManagementPolicyRule"));
        } else {
            definition().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagementPolicyRule.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("definition", this.definition);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagementPolicyRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagementPolicyRule if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagementPolicyRule.
     */
    public static ManagementPolicyRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagementPolicyRule deserializedManagementPolicyRule = new ManagementPolicyRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedManagementPolicyRule.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagementPolicyRule.type = RuleType.fromString(reader.getString());
                } else if ("definition".equals(fieldName)) {
                    deserializedManagementPolicyRule.definition = ManagementPolicyDefinition.fromJson(reader);
                } else if ("enabled".equals(fieldName)) {
                    deserializedManagementPolicyRule.enabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagementPolicyRule;
        });
    }
}
