// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The FileServiceItems model.
 */
@Immutable
public final class FileServiceItemsInner implements JsonSerializable<FileServiceItemsInner> {
    /*
     * List of file services returned.
     */
    private List<FileServicePropertiesInner> value;

    /**
     * Creates an instance of FileServiceItemsInner class.
     */
    public FileServiceItemsInner() {
    }

    /**
     * Get the value property: List of file services returned.
     * 
     * @return the value value.
     */
    public List<FileServicePropertiesInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileServiceItemsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileServiceItemsInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileServiceItemsInner.
     */
    public static FileServiceItemsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileServiceItemsInner deserializedFileServiceItemsInner = new FileServiceItemsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<FileServicePropertiesInner> value
                        = reader.readArray(reader1 -> FileServicePropertiesInner.fromJson(reader1));
                    deserializedFileServiceItemsInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileServiceItemsInner;
        });
    }
}
