/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.Bypass;
import com.azure.resourcemanager.storage.models.DefaultAction;
import com.azure.resourcemanager.storage.models.IpRule;
import com.azure.resourcemanager.storage.models.ResourceAccessRule;
import com.azure.resourcemanager.storage.models.VirtualNetworkRule;
import java.io.IOException;
import java.util.List;

public final class NetworkRuleSet
implements JsonSerializable<NetworkRuleSet> {
    private Bypass bypass;
    private List<ResourceAccessRule> resourceAccessRules;
    private List<VirtualNetworkRule> virtualNetworkRules;
    private List<IpRule> ipRules;
    private DefaultAction defaultAction;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkRuleSet.class);

    public Bypass bypass() {
        return this.bypass;
    }

    public NetworkRuleSet withBypass(Bypass bypass) {
        this.bypass = bypass;
        return this;
    }

    public List<ResourceAccessRule> resourceAccessRules() {
        return this.resourceAccessRules;
    }

    public NetworkRuleSet withResourceAccessRules(List<ResourceAccessRule> resourceAccessRules) {
        this.resourceAccessRules = resourceAccessRules;
        return this;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public NetworkRuleSet withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public List<IpRule> ipRules() {
        return this.ipRules;
    }

    public NetworkRuleSet withIpRules(List<IpRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public DefaultAction defaultAction() {
        return this.defaultAction;
    }

    public NetworkRuleSet withDefaultAction(DefaultAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    public void validate() {
        if (this.resourceAccessRules() != null) {
            this.resourceAccessRules().forEach(e -> e.validate());
        }
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
        if (this.defaultAction() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property defaultAction in model NetworkRuleSet"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultAction", this.defaultAction == null ? null : this.defaultAction.toString());
        jsonWriter.writeStringField("bypass", this.bypass == null ? null : this.bypass.toString());
        jsonWriter.writeArrayField("resourceAccessRules", this.resourceAccessRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("virtualNetworkRules", this.virtualNetworkRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkRuleSet fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkRuleSet)jsonReader.readObject(reader -> {
            NetworkRuleSet deserializedNetworkRuleSet = new NetworkRuleSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("defaultAction".equals(fieldName)) {
                    deserializedNetworkRuleSet.defaultAction = DefaultAction.fromString(reader.getString());
                    continue;
                }
                if ("bypass".equals(fieldName)) {
                    deserializedNetworkRuleSet.bypass = Bypass.fromString(reader.getString());
                    continue;
                }
                if ("resourceAccessRules".equals(fieldName)) {
                    List resourceAccessRules;
                    deserializedNetworkRuleSet.resourceAccessRules = resourceAccessRules = reader.readArray(reader1 -> ResourceAccessRule.fromJson(reader1));
                    continue;
                }
                if ("virtualNetworkRules".equals(fieldName)) {
                    List virtualNetworkRules;
                    deserializedNetworkRuleSet.virtualNetworkRules = virtualNetworkRules = reader.readArray(reader1 -> VirtualNetworkRule.fromJson(reader1));
                    continue;
                }
                if ("ipRules".equals(fieldName)) {
                    List ipRules;
                    deserializedNetworkRuleSet.ipRules = ipRules = reader.readArray(reader1 -> IpRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkRuleSet;
        });
    }
}

