/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.TriggerParametersUpdate;
import com.azure.resourcemanager.storage.models.TriggerType;
import java.io.IOException;

public final class ExecutionTriggerUpdate
implements JsonSerializable<ExecutionTriggerUpdate> {
    private TriggerType type;
    private TriggerParametersUpdate parameters;

    public TriggerType type() {
        return this.type;
    }

    public ExecutionTriggerUpdate withType(TriggerType type) {
        this.type = type;
        return this;
    }

    public TriggerParametersUpdate parameters() {
        return this.parameters;
    }

    public ExecutionTriggerUpdate withParameters(TriggerParametersUpdate parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.parameters() != null) {
            this.parameters().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static ExecutionTriggerUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutionTriggerUpdate)jsonReader.readObject(reader -> {
            ExecutionTriggerUpdate deserializedExecutionTriggerUpdate = new ExecutionTriggerUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedExecutionTriggerUpdate.type = TriggerType.fromString(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedExecutionTriggerUpdate.parameters = TriggerParametersUpdate.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecutionTriggerUpdate;
        });
    }
}

