// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.TableSignedIdentifier;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the table, including Id, resource name, resource type.
 */
@Fluent
public final class TableInner extends ProxyResource {
    /*
     * Table resource properties.
     */
    private TableProperties innerTableProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of TableInner class.
     */
    public TableInner() {
    }

    /**
     * Get the innerTableProperties property: Table resource properties.
     * 
     * @return the innerTableProperties value.
     */
    private TableProperties innerTableProperties() {
        return this.innerTableProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the tableName property: Table name under the specified account.
     * 
     * @return the tableName value.
     */
    public String tableName() {
        return this.innerTableProperties() == null ? null : this.innerTableProperties().tableName();
    }

    /**
     * Get the signedIdentifiers property: List of stored access policies specified on the table.
     * 
     * @return the signedIdentifiers value.
     */
    public List<TableSignedIdentifier> signedIdentifiers() {
        return this.innerTableProperties() == null ? null : this.innerTableProperties().signedIdentifiers();
    }

    /**
     * Set the signedIdentifiers property: List of stored access policies specified on the table.
     * 
     * @param signedIdentifiers the signedIdentifiers value to set.
     * @return the TableInner object itself.
     */
    public TableInner withSignedIdentifiers(List<TableSignedIdentifier> signedIdentifiers) {
        if (this.innerTableProperties() == null) {
            this.innerTableProperties = new TableProperties();
        }
        this.innerTableProperties().withSignedIdentifiers(signedIdentifiers);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerTableProperties() != null) {
            innerTableProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerTableProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TableInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TableInner if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TableInner.
     */
    public static TableInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TableInner deserializedTableInner = new TableInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTableInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedTableInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedTableInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedTableInner.innerTableProperties = TableProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTableInner;
        });
    }
}
