/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.FileShareProperties;
import com.azure.resourcemanager.storage.models.AzureEntityResource;
import com.azure.resourcemanager.storage.models.EnabledProtocols;
import com.azure.resourcemanager.storage.models.FileSharePropertiesFileSharePaidBursting;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.RootSquashType;
import com.azure.resourcemanager.storage.models.ShareAccessTier;
import com.azure.resourcemanager.storage.models.SignedIdentifier;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class FileShareItemInner
extends AzureEntityResource {
    private FileShareProperties innerProperties;
    private String etag;
    private String type;
    private String name;
    private String id;

    private FileShareProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public Map<String, String> metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public FileShareItemInner withMetadata(Map<String, String> metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FileShareProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public Integer shareQuota() {
        return this.innerProperties() == null ? null : this.innerProperties().shareQuota();
    }

    public FileShareItemInner withShareQuota(Integer shareQuota) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FileShareProperties();
        }
        this.innerProperties().withShareQuota(shareQuota);
        return this;
    }

    public Integer provisionedIops() {
        return this.innerProperties() == null ? null : this.innerProperties().provisionedIops();
    }

    public FileShareItemInner withProvisionedIops(Integer provisionedIops) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FileShareProperties();
        }
        this.innerProperties().withProvisionedIops(provisionedIops);
        return this;
    }

    public Integer provisionedBandwidthMibps() {
        return this.innerProperties() == null ? null : this.innerProperties().provisionedBandwidthMibps();
    }

    public FileShareItemInner withProvisionedBandwidthMibps(Integer provisionedBandwidthMibps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FileShareProperties();
        }
        this.innerProperties().withProvisionedBandwidthMibps(provisionedBandwidthMibps);
        return this;
    }

    public Integer includedBurstIops() {
        return this.innerProperties() == null ? null : this.innerProperties().includedBurstIops();
    }

    public Long maxBurstCreditsForIops() {
        return this.innerProperties() == null ? null : this.innerProperties().maxBurstCreditsForIops();
    }

    public OffsetDateTime nextAllowedQuotaDowngradeTime() {
        return this.innerProperties() == null ? null : this.innerProperties().nextAllowedQuotaDowngradeTime();
    }

    public OffsetDateTime nextAllowedProvisionedIopsDowngradeTime() {
        return this.innerProperties() == null ? null : this.innerProperties().nextAllowedProvisionedIopsDowngradeTime();
    }

    public OffsetDateTime nextAllowedProvisionedBandwidthDowngradeTime() {
        return this.innerProperties() == null ? null : this.innerProperties().nextAllowedProvisionedBandwidthDowngradeTime();
    }

    public EnabledProtocols enabledProtocols() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledProtocols();
    }

    public FileShareItemInner withEnabledProtocols(EnabledProtocols enabledProtocols) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FileShareProperties();
        }
        this.innerProperties().withEnabledProtocols(enabledProtocols);
        return this;
    }

    public RootSquashType rootSquash() {
        return this.innerProperties() == null ? null : this.innerProperties().rootSquash();
    }

    public FileShareItemInner withRootSquash(RootSquashType rootSquash) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FileShareProperties();
        }
        this.innerProperties().withRootSquash(rootSquash);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public Boolean deleted() {
        return this.innerProperties() == null ? null : this.innerProperties().deleted();
    }

    public OffsetDateTime deletedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().deletedTime();
    }

    public Integer remainingRetentionDays() {
        return this.innerProperties() == null ? null : this.innerProperties().remainingRetentionDays();
    }

    public ShareAccessTier accessTier() {
        return this.innerProperties() == null ? null : this.innerProperties().accessTier();
    }

    public FileShareItemInner withAccessTier(ShareAccessTier accessTier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FileShareProperties();
        }
        this.innerProperties().withAccessTier(accessTier);
        return this;
    }

    public OffsetDateTime accessTierChangeTime() {
        return this.innerProperties() == null ? null : this.innerProperties().accessTierChangeTime();
    }

    public String accessTierStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().accessTierStatus();
    }

    public Long shareUsageBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().shareUsageBytes();
    }

    public LeaseStatus leaseStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().leaseStatus();
    }

    public LeaseState leaseState() {
        return this.innerProperties() == null ? null : this.innerProperties().leaseState();
    }

    public LeaseDuration leaseDuration() {
        return this.innerProperties() == null ? null : this.innerProperties().leaseDuration();
    }

    public List<SignedIdentifier> signedIdentifiers() {
        return this.innerProperties() == null ? null : this.innerProperties().signedIdentifiers();
    }

    public FileShareItemInner withSignedIdentifiers(List<SignedIdentifier> signedIdentifiers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FileShareProperties();
        }
        this.innerProperties().withSignedIdentifiers(signedIdentifiers);
        return this;
    }

    public OffsetDateTime snapshotTime() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotTime();
    }

    public FileSharePropertiesFileSharePaidBursting fileSharePaidBursting() {
        return this.innerProperties() == null ? null : this.innerProperties().fileSharePaidBursting();
    }

    public FileShareItemInner withFileSharePaidBursting(FileSharePropertiesFileSharePaidBursting fileSharePaidBursting) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FileShareProperties();
        }
        this.innerProperties().withFileSharePaidBursting(fileSharePaidBursting);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static FileShareItemInner fromJson(JsonReader jsonReader) throws IOException {
        return (FileShareItemInner)((Object)jsonReader.readObject(reader -> {
            FileShareItemInner deserializedFileShareItemInner = new FileShareItemInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedFileShareItemInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFileShareItemInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFileShareItemInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedFileShareItemInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFileShareItemInner.innerProperties = FileShareProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileShareItemInner;
        }));
    }
}

