// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Object to set Table Access Policy.
 */
@Fluent
public final class TableSignedIdentifier implements JsonSerializable<TableSignedIdentifier> {
    /*
     * unique-64-character-value of the stored access policy.
     */
    private String id;

    /*
     * Access policy
     */
    private TableAccessPolicy accessPolicy;

    /**
     * Creates an instance of TableSignedIdentifier class.
     */
    public TableSignedIdentifier() {
    }

    /**
     * Get the id property: unique-64-character-value of the stored access policy.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: unique-64-character-value of the stored access policy.
     * 
     * @param id the id value to set.
     * @return the TableSignedIdentifier object itself.
     */
    public TableSignedIdentifier withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the accessPolicy property: Access policy.
     * 
     * @return the accessPolicy value.
     */
    public TableAccessPolicy accessPolicy() {
        return this.accessPolicy;
    }

    /**
     * Set the accessPolicy property: Access policy.
     * 
     * @param accessPolicy the accessPolicy value to set.
     * @return the TableSignedIdentifier object itself.
     */
    public TableSignedIdentifier withAccessPolicy(TableAccessPolicy accessPolicy) {
        this.accessPolicy = accessPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model TableSignedIdentifier"));
        }
        if (accessPolicy() != null) {
            accessPolicy().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TableSignedIdentifier.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("accessPolicy", this.accessPolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TableSignedIdentifier from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TableSignedIdentifier if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TableSignedIdentifier.
     */
    public static TableSignedIdentifier fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TableSignedIdentifier deserializedTableSignedIdentifier = new TableSignedIdentifier();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTableSignedIdentifier.id = reader.getString();
                } else if ("accessPolicy".equals(fieldName)) {
                    deserializedTableSignedIdentifier.accessPolicy = TableAccessPolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTableSignedIdentifier;
        });
    }
}
