// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about resource association.
 */
@Fluent
public final class NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation
    implements JsonSerializable<NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation> {
    /*
     * Name of the resource association
     */
    private String name;

    /*
     * Access Mode of the resource association
     */
    private ResourceAssociationAccessMode accessMode;

    /**
     * Creates an instance of NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation class.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation() {
    }

    /**
     * Get the name property: Name of the resource association.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the resource association.
     * 
     * @param name the name value to set.
     * @return the NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation object itself.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the accessMode property: Access Mode of the resource association.
     * 
     * @return the accessMode value.
     */
    public ResourceAssociationAccessMode accessMode() {
        return this.accessMode;
    }

    /**
     * Set the accessMode property: Access Mode of the resource association.
     * 
     * @param accessMode the accessMode value to set.
     * @return the NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation object itself.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation
        withAccessMode(ResourceAssociationAccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("accessMode", this.accessMode == null ? null : this.accessMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation if the JsonReader was
     * pointing to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation.
     */
    public static NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation deserializedNetworkSecurityPerimeterConfigurationPropertiesResourceAssociation
                = new NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationPropertiesResourceAssociation.name
                        = reader.getString();
                } else if ("accessMode".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationPropertiesResourceAssociation.accessMode
                        = ResourceAssociationAccessMode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityPerimeterConfigurationPropertiesResourceAssociation;
        });
    }
}
