// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Properties of key vault.
 */
@Fluent
public final class KeyVaultProperties implements JsonSerializable<KeyVaultProperties> {
    /*
     * The name of KeyVault key.
     */
    private String keyName;

    /*
     * The version of KeyVault key.
     */
    private String keyVersion;

    /*
     * The Uri of KeyVault.
     */
    private String keyVaultUri;

    /*
     * The object identifier of the current versioned Key Vault Key in use.
     */
    private String currentVersionedKeyIdentifier;

    /*
     * Timestamp of last rotation of the Key Vault Key.
     */
    private OffsetDateTime lastKeyRotationTimestamp;

    /*
     * This is a read only property that represents the expiration time of the current version of the customer managed
     * key used for encryption.
     */
    private OffsetDateTime currentVersionedKeyExpirationTimestamp;

    /**
     * Creates an instance of KeyVaultProperties class.
     */
    public KeyVaultProperties() {
    }

    /**
     * Get the keyName property: The name of KeyVault key.
     * 
     * @return the keyName value.
     */
    public String keyName() {
        return this.keyName;
    }

    /**
     * Set the keyName property: The name of KeyVault key.
     * 
     * @param keyName the keyName value to set.
     * @return the KeyVaultProperties object itself.
     */
    public KeyVaultProperties withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    /**
     * Get the keyVersion property: The version of KeyVault key.
     * 
     * @return the keyVersion value.
     */
    public String keyVersion() {
        return this.keyVersion;
    }

    /**
     * Set the keyVersion property: The version of KeyVault key.
     * 
     * @param keyVersion the keyVersion value to set.
     * @return the KeyVaultProperties object itself.
     */
    public KeyVaultProperties withKeyVersion(String keyVersion) {
        this.keyVersion = keyVersion;
        return this;
    }

    /**
     * Get the keyVaultUri property: The Uri of KeyVault.
     * 
     * @return the keyVaultUri value.
     */
    public String keyVaultUri() {
        return this.keyVaultUri;
    }

    /**
     * Set the keyVaultUri property: The Uri of KeyVault.
     * 
     * @param keyVaultUri the keyVaultUri value to set.
     * @return the KeyVaultProperties object itself.
     */
    public KeyVaultProperties withKeyVaultUri(String keyVaultUri) {
        this.keyVaultUri = keyVaultUri;
        return this;
    }

    /**
     * Get the currentVersionedKeyIdentifier property: The object identifier of the current versioned Key Vault Key in
     * use.
     * 
     * @return the currentVersionedKeyIdentifier value.
     */
    public String currentVersionedKeyIdentifier() {
        return this.currentVersionedKeyIdentifier;
    }

    /**
     * Get the lastKeyRotationTimestamp property: Timestamp of last rotation of the Key Vault Key.
     * 
     * @return the lastKeyRotationTimestamp value.
     */
    public OffsetDateTime lastKeyRotationTimestamp() {
        return this.lastKeyRotationTimestamp;
    }

    /**
     * Get the currentVersionedKeyExpirationTimestamp property: This is a read only property that represents the
     * expiration time of the current version of the customer managed key used for encryption.
     * 
     * @return the currentVersionedKeyExpirationTimestamp value.
     */
    public OffsetDateTime currentVersionedKeyExpirationTimestamp() {
        return this.currentVersionedKeyExpirationTimestamp;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyname", this.keyName);
        jsonWriter.writeStringField("keyversion", this.keyVersion);
        jsonWriter.writeStringField("keyvaulturi", this.keyVaultUri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVaultProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVaultProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyVaultProperties.
     */
    public static KeyVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultProperties deserializedKeyVaultProperties = new KeyVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyname".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyName = reader.getString();
                } else if ("keyversion".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyVersion = reader.getString();
                } else if ("keyvaulturi".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyVaultUri = reader.getString();
                } else if ("currentVersionedKeyIdentifier".equals(fieldName)) {
                    deserializedKeyVaultProperties.currentVersionedKeyIdentifier = reader.getString();
                } else if ("lastKeyRotationTimestamp".equals(fieldName)) {
                    deserializedKeyVaultProperties.lastKeyRotationTimestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("currentVersionedKeyExpirationTimestamp".equals(fieldName)) {
                    deserializedKeyVaultProperties.currentVersionedKeyExpirationTimestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVaultProperties;
        });
    }
}
