// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The authentication protocol that is used for the file share. Can only be specified when creating a share.
 */
public final class EnabledProtocols extends ExpandableStringEnum<EnabledProtocols> {
    /**
     * Static value SMB for EnabledProtocols.
     */
    public static final EnabledProtocols SMB = fromString("SMB");

    /**
     * Static value NFS for EnabledProtocols.
     */
    public static final EnabledProtocols NFS = fromString("NFS");

    /**
     * Creates a new instance of EnabledProtocols value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public EnabledProtocols() {
    }

    /**
     * Creates or finds a EnabledProtocols from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding EnabledProtocols.
     */
    public static EnabledProtocols fromString(String name) {
        return fromString(name, EnabledProtocols.class);
    }

    /**
     * Gets known EnabledProtocols values.
     * 
     * @return known EnabledProtocols values.
     */
    public static Collection<EnabledProtocols> values() {
        return values(EnabledProtocols.class);
    }
}
