// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The ImmutabilityPolicy state defines the mode of the policy. Disabled state disables the policy, Unlocked state
 * allows increase and decrease of immutability retention time and also allows toggling allowProtectedAppendWrites
 * property, Locked state only allows the increase of the immutability retention time. A policy can only be created in a
 * Disabled or Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state can
 * transition to a Locked state which cannot be reverted.
 */
public final class AccountImmutabilityPolicyState extends ExpandableStringEnum<AccountImmutabilityPolicyState> {
    /**
     * Static value Unlocked for AccountImmutabilityPolicyState.
     */
    public static final AccountImmutabilityPolicyState UNLOCKED = fromString("Unlocked");

    /**
     * Static value Locked for AccountImmutabilityPolicyState.
     */
    public static final AccountImmutabilityPolicyState LOCKED = fromString("Locked");

    /**
     * Static value Disabled for AccountImmutabilityPolicyState.
     */
    public static final AccountImmutabilityPolicyState DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of AccountImmutabilityPolicyState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AccountImmutabilityPolicyState() {
    }

    /**
     * Creates or finds a AccountImmutabilityPolicyState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AccountImmutabilityPolicyState.
     */
    public static AccountImmutabilityPolicyState fromString(String name) {
        return fromString(name, AccountImmutabilityPolicyState.class);
    }

    /**
     * Gets known AccountImmutabilityPolicyState values.
     * 
     * @return known AccountImmutabilityPolicyState values.
     */
    public static Collection<AccountImmutabilityPolicyState> values() {
        return values(AccountImmutabilityPolicyState.class);
    }
}
