// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.UsageName;
import com.azure.resourcemanager.storage.models.UsageUnit;
import java.io.IOException;

/**
 * Describes Storage Resource Usage.
 */
@Immutable
public final class UsageInner implements JsonSerializable<UsageInner> {
    /*
     * Gets the unit of measurement.
     */
    private UsageUnit unit;

    /*
     * Gets the current count of the allocated resources in the subscription.
     */
    private Integer currentValue;

    /*
     * Gets the maximum count of the resources that can be allocated in the subscription.
     */
    private Integer limit;

    /*
     * Gets the name of the type of usage.
     */
    private UsageName name;

    /**
     * Creates an instance of UsageInner class.
     */
    public UsageInner() {
    }

    /**
     * Get the unit property: Gets the unit of measurement.
     * 
     * @return the unit value.
     */
    public UsageUnit unit() {
        return this.unit;
    }

    /**
     * Get the currentValue property: Gets the current count of the allocated resources in the subscription.
     * 
     * @return the currentValue value.
     */
    public Integer currentValue() {
        return this.currentValue;
    }

    /**
     * Get the limit property: Gets the maximum count of the resources that can be allocated in the subscription.
     * 
     * @return the limit value.
     */
    public Integer limit() {
        return this.limit;
    }

    /**
     * Get the name property: Gets the name of the type of usage.
     * 
     * @return the name value.
     */
    public UsageName name() {
        return this.name;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() != null) {
            name().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UsageInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UsageInner if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the UsageInner.
     */
    public static UsageInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UsageInner deserializedUsageInner = new UsageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("unit".equals(fieldName)) {
                    deserializedUsageInner.unit = UsageUnit.fromString(reader.getString());
                } else if ("currentValue".equals(fieldName)) {
                    deserializedUsageInner.currentValue = reader.getNullable(JsonReader::getInt);
                } else if ("limit".equals(fieldName)) {
                    deserializedUsageInner.limit = reader.getNullable(JsonReader::getInt);
                } else if ("name".equals(fieldName)) {
                    deserializedUsageInner.name = UsageName.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUsageInner;
        });
    }
}
