// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.MigrationStatus;
import com.azure.resourcemanager.storage.models.SkuName;
import java.io.IOException;

/**
 * The parameters or status associated with an ongoing or enqueued storage account migration in order to update its
 * current SKU or region.
 */
@Fluent
public final class StorageAccountMigrationInner implements JsonSerializable<StorageAccountMigrationInner> {
    /*
     * Migration Resource Id
     */
    private String id;

    /*
     * current value is 'default' for customer initiated migration
     */
    private String name;

    /*
     * SrpAccountMigrationType in ARM contract which is 'accountMigrations'
     */
    private String type;

    /*
     * The properties of a storage account’s ongoing or enqueued migration.
     */
    private StorageAccountMigrationProperties innerStorageAccountMigrationDetails
        = new StorageAccountMigrationProperties();

    /**
     * Creates an instance of StorageAccountMigrationInner class.
     */
    public StorageAccountMigrationInner() {
    }

    /**
     * Get the id property: Migration Resource Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: current value is 'default' for customer initiated migration.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: current value is 'default' for customer initiated migration.
     * 
     * @param name the name value to set.
     * @return the StorageAccountMigrationInner object itself.
     */
    public StorageAccountMigrationInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: SrpAccountMigrationType in ARM contract which is 'accountMigrations'.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: SrpAccountMigrationType in ARM contract which is 'accountMigrations'.
     * 
     * @param type the type value to set.
     * @return the StorageAccountMigrationInner object itself.
     */
    public StorageAccountMigrationInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the innerStorageAccountMigrationDetails property: The properties of a storage account’s ongoing or enqueued
     * migration.
     * 
     * @return the innerStorageAccountMigrationDetails value.
     */
    private StorageAccountMigrationProperties innerStorageAccountMigrationDetails() {
        return this.innerStorageAccountMigrationDetails;
    }

    /**
     * Get the targetSkuName property: Target sku name for the account.
     * 
     * @return the targetSkuName value.
     */
    public SkuName targetSkuName() {
        return this.innerStorageAccountMigrationDetails() == null
            ? null
            : this.innerStorageAccountMigrationDetails().targetSkuName();
    }

    /**
     * Set the targetSkuName property: Target sku name for the account.
     * 
     * @param targetSkuName the targetSkuName value to set.
     * @return the StorageAccountMigrationInner object itself.
     */
    public StorageAccountMigrationInner withTargetSkuName(SkuName targetSkuName) {
        if (this.innerStorageAccountMigrationDetails() == null) {
            this.innerStorageAccountMigrationDetails = new StorageAccountMigrationProperties();
        }
        this.innerStorageAccountMigrationDetails().withTargetSkuName(targetSkuName);
        return this;
    }

    /**
     * Get the migrationStatus property: Current status of migration.
     * 
     * @return the migrationStatus value.
     */
    public MigrationStatus migrationStatus() {
        return this.innerStorageAccountMigrationDetails() == null
            ? null
            : this.innerStorageAccountMigrationDetails().migrationStatus();
    }

    /**
     * Get the migrationFailedReason property: Error code for migration failure.
     * 
     * @return the migrationFailedReason value.
     */
    public String migrationFailedReason() {
        return this.innerStorageAccountMigrationDetails() == null
            ? null
            : this.innerStorageAccountMigrationDetails().migrationFailedReason();
    }

    /**
     * Get the migrationFailedDetailedReason property: Reason for migration failure.
     * 
     * @return the migrationFailedDetailedReason value.
     */
    public String migrationFailedDetailedReason() {
        return this.innerStorageAccountMigrationDetails() == null
            ? null
            : this.innerStorageAccountMigrationDetails().migrationFailedDetailedReason();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerStorageAccountMigrationDetails() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerStorageAccountMigrationDetails in model StorageAccountMigrationInner"));
        } else {
            innerStorageAccountMigrationDetails().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(StorageAccountMigrationInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerStorageAccountMigrationDetails);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageAccountMigrationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageAccountMigrationInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StorageAccountMigrationInner.
     */
    public static StorageAccountMigrationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageAccountMigrationInner deserializedStorageAccountMigrationInner = new StorageAccountMigrationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedStorageAccountMigrationInner.innerStorageAccountMigrationDetails
                        = StorageAccountMigrationProperties.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedStorageAccountMigrationInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStorageAccountMigrationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStorageAccountMigrationInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageAccountMigrationInner;
        });
    }
}
