// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.BlobInventoryPolicySchema;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The storage account blob inventory policy properties.
 */
@Fluent
public final class BlobInventoryPolicyProperties implements JsonSerializable<BlobInventoryPolicyProperties> {
    /*
     * Returns the last modified date and time of the blob inventory policy.
     */
    private OffsetDateTime lastModifiedTime;

    /*
     * The storage account blob inventory policy object. It is composed of policy rules.
     */
    private BlobInventoryPolicySchema policy;

    /**
     * Creates an instance of BlobInventoryPolicyProperties class.
     */
    public BlobInventoryPolicyProperties() {
    }

    /**
     * Get the lastModifiedTime property: Returns the last modified date and time of the blob inventory policy.
     * 
     * @return the lastModifiedTime value.
     */
    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Get the policy property: The storage account blob inventory policy object. It is composed of policy rules.
     * 
     * @return the policy value.
     */
    public BlobInventoryPolicySchema policy() {
        return this.policy;
    }

    /**
     * Set the policy property: The storage account blob inventory policy object. It is composed of policy rules.
     * 
     * @param policy the policy value to set.
     * @return the BlobInventoryPolicyProperties object itself.
     */
    public BlobInventoryPolicyProperties withPolicy(BlobInventoryPolicySchema policy) {
        this.policy = policy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (policy() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property policy in model BlobInventoryPolicyProperties"));
        } else {
            policy().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BlobInventoryPolicyProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("policy", this.policy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BlobInventoryPolicyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BlobInventoryPolicyProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BlobInventoryPolicyProperties.
     */
    public static BlobInventoryPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BlobInventoryPolicyProperties deserializedBlobInventoryPolicyProperties
                = new BlobInventoryPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("policy".equals(fieldName)) {
                    deserializedBlobInventoryPolicyProperties.policy = BlobInventoryPolicySchema.fromJson(reader);
                } else if ("lastModifiedTime".equals(fieldName)) {
                    deserializedBlobInventoryPolicyProperties.lastModifiedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBlobInventoryPolicyProperties;
        });
    }
}
