/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.IssueType;
import com.azure.resourcemanager.storage.models.Severity;
import java.io.IOException;

public final class ProvisioningIssueProperties
implements JsonSerializable<ProvisioningIssueProperties> {
    private IssueType issueType;
    private Severity severity;
    private String description;

    public IssueType issueType() {
        return this.issueType;
    }

    public ProvisioningIssueProperties withIssueType(IssueType issueType) {
        this.issueType = issueType;
        return this;
    }

    public Severity severity() {
        return this.severity;
    }

    public ProvisioningIssueProperties withSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ProvisioningIssueProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("issueType", this.issueType == null ? null : this.issueType.toString());
        jsonWriter.writeStringField("severity", this.severity == null ? null : this.severity.toString());
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ProvisioningIssueProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProvisioningIssueProperties)jsonReader.readObject(reader -> {
            ProvisioningIssueProperties deserializedProvisioningIssueProperties = new ProvisioningIssueProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("issueType".equals(fieldName)) {
                    deserializedProvisioningIssueProperties.issueType = IssueType.fromString(reader.getString());
                    continue;
                }
                if ("severity".equals(fieldName)) {
                    deserializedProvisioningIssueProperties.severity = Severity.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedProvisioningIssueProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProvisioningIssueProperties;
        });
    }
}

