// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information of Access Rule in Network Security Perimeter profile.
 */
@Fluent
public final class NspAccessRule implements JsonSerializable<NspAccessRule> {
    /*
     * Name of the resource
     */
    private String name;

    /*
     * Properties of Access Rule
     */
    private NspAccessRuleProperties properties;

    /**
     * Creates an instance of NspAccessRule class.
     */
    public NspAccessRule() {
    }

    /**
     * Get the name property: Name of the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the resource.
     * 
     * @param name the name value to set.
     * @return the NspAccessRule object itself.
     */
    public NspAccessRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the properties property: Properties of Access Rule.
     * 
     * @return the properties value.
     */
    public NspAccessRuleProperties properties() {
        return this.properties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspAccessRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspAccessRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspAccessRule.
     */
    public static NspAccessRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspAccessRule deserializedNspAccessRule = new NspAccessRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedNspAccessRule.name = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedNspAccessRule.properties = NspAccessRuleProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspAccessRule;
        });
    }
}
