// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The blob service properties for change feed events.
 */
@Fluent
public final class ChangeFeed implements JsonSerializable<ChangeFeed> {
    /*
     * Indicates whether change feed event logging is enabled for the Blob service.
     */
    private Boolean enabled;

    /*
     * Indicates the duration of changeFeed retention in days. Minimum value is 1 day and maximum value is 146000 days
     * (400 years). A null value indicates an infinite retention of the change feed.
     */
    private Integer retentionInDays;

    /**
     * Creates an instance of ChangeFeed class.
     */
    public ChangeFeed() {
    }

    /**
     * Get the enabled property: Indicates whether change feed event logging is enabled for the Blob service.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether change feed event logging is enabled for the Blob service.
     * 
     * @param enabled the enabled value to set.
     * @return the ChangeFeed object itself.
     */
    public ChangeFeed withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the retentionInDays property: Indicates the duration of changeFeed retention in days. Minimum value is 1 day
     * and maximum value is 146000 days (400 years). A null value indicates an infinite retention of the change feed.
     * 
     * @return the retentionInDays value.
     */
    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    /**
     * Set the retentionInDays property: Indicates the duration of changeFeed retention in days. Minimum value is 1 day
     * and maximum value is 146000 days (400 years). A null value indicates an infinite retention of the change feed.
     * 
     * @param retentionInDays the retentionInDays value to set.
     * @return the ChangeFeed object itself.
     */
    public ChangeFeed withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("retentionInDays", this.retentionInDays);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChangeFeed from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChangeFeed if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the ChangeFeed.
     */
    public static ChangeFeed fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChangeFeed deserializedChangeFeed = new ChangeFeed();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedChangeFeed.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("retentionInDays".equals(fieldName)) {
                    deserializedChangeFeed.retentionInDays = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedChangeFeed;
        });
    }
}
