// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.StorageTaskReportProperties;
import java.io.IOException;

/**
 * Storage Tasks run report instance.
 */
@Fluent
public final class StorageTaskReportInstanceInner extends ProxyResource {
    /*
     * Storage task execution report for a run instance.
     */
    private StorageTaskReportProperties properties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of StorageTaskReportInstanceInner class.
     */
    public StorageTaskReportInstanceInner() {
    }

    /**
     * Get the properties property: Storage task execution report for a run instance.
     * 
     * @return the properties value.
     */
    public StorageTaskReportProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Storage task execution report for a run instance.
     * 
     * @param properties the properties value to set.
     * @return the StorageTaskReportInstanceInner object itself.
     */
    public StorageTaskReportInstanceInner withProperties(StorageTaskReportProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageTaskReportInstanceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageTaskReportInstanceInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StorageTaskReportInstanceInner.
     */
    public static StorageTaskReportInstanceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageTaskReportInstanceInner deserializedStorageTaskReportInstanceInner
                = new StorageTaskReportInstanceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStorageTaskReportInstanceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStorageTaskReportInstanceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStorageTaskReportInstanceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedStorageTaskReportInstanceInner.properties
                        = StorageTaskReportProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageTaskReportInstanceInner;
        });
    }
}
