/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.TableSignedIdentifier;
import java.io.IOException;
import java.util.List;

public final class TableProperties
implements JsonSerializable<TableProperties> {
    private String tableName;
    private List<TableSignedIdentifier> signedIdentifiers;

    public String tableName() {
        return this.tableName;
    }

    public List<TableSignedIdentifier> signedIdentifiers() {
        return this.signedIdentifiers;
    }

    public TableProperties withSignedIdentifiers(List<TableSignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
        return this;
    }

    public void validate() {
        if (this.signedIdentifiers() != null) {
            this.signedIdentifiers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("signedIdentifiers", this.signedIdentifiers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TableProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TableProperties)jsonReader.readObject(reader -> {
            TableProperties deserializedTableProperties = new TableProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tableName".equals(fieldName)) {
                    deserializedTableProperties.tableName = reader.getString();
                    continue;
                }
                if ("signedIdentifiers".equals(fieldName)) {
                    List signedIdentifiers;
                    deserializedTableProperties.signedIdentifiers = signedIdentifiers = reader.readArray(reader1 -> TableSignedIdentifier.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableProperties;
        });
    }
}

