/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.TableProperties;
import com.azure.resourcemanager.storage.models.TableSignedIdentifier;
import java.io.IOException;
import java.util.List;

public final class TableInner
extends ProxyResource {
    private TableProperties innerTableProperties;
    private String id;
    private String name;
    private String type;

    private TableProperties innerTableProperties() {
        return this.innerTableProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String tableName() {
        return this.innerTableProperties() == null ? null : this.innerTableProperties().tableName();
    }

    public List<TableSignedIdentifier> signedIdentifiers() {
        return this.innerTableProperties() == null ? null : this.innerTableProperties().signedIdentifiers();
    }

    public TableInner withSignedIdentifiers(List<TableSignedIdentifier> signedIdentifiers) {
        if (this.innerTableProperties() == null) {
            this.innerTableProperties = new TableProperties();
        }
        this.innerTableProperties().withSignedIdentifiers(signedIdentifiers);
        return this;
    }

    public void validate() {
        if (this.innerTableProperties() != null) {
            this.innerTableProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerTableProperties);
        return jsonWriter.writeEndObject();
    }

    public static TableInner fromJson(JsonReader jsonReader) throws IOException {
        return (TableInner)((Object)jsonReader.readObject(reader -> {
            TableInner deserializedTableInner = new TableInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTableInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTableInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTableInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTableInner.innerTableProperties = TableProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableInner;
        }));
    }
}

