/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.FileShareProperties;
import com.azure.resourcemanager.storage.models.AzureEntityResource;
import com.azure.resourcemanager.storage.models.EnabledProtocols;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.RootSquashType;
import com.azure.resourcemanager.storage.models.ShareAccessTier;
import com.azure.resourcemanager.storage.models.SignedIdentifier;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class FileShareInner
extends AzureEntityResource {
    private FileShareProperties innerFileShareProperties;
    private String id;
    private String name;
    private String type;
    private String etag;

    private FileShareProperties innerFileShareProperties() {
        return this.innerFileShareProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().lastModifiedTime();
    }

    public Map<String, String> metadata() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().metadata();
    }

    public FileShareInner withMetadata(Map<String, String> metadata) {
        if (this.innerFileShareProperties() == null) {
            this.innerFileShareProperties = new FileShareProperties();
        }
        this.innerFileShareProperties().withMetadata(metadata);
        return this;
    }

    public Integer shareQuota() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().shareQuota();
    }

    public FileShareInner withShareQuota(Integer shareQuota) {
        if (this.innerFileShareProperties() == null) {
            this.innerFileShareProperties = new FileShareProperties();
        }
        this.innerFileShareProperties().withShareQuota(shareQuota);
        return this;
    }

    public EnabledProtocols enabledProtocols() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().enabledProtocols();
    }

    public FileShareInner withEnabledProtocols(EnabledProtocols enabledProtocols) {
        if (this.innerFileShareProperties() == null) {
            this.innerFileShareProperties = new FileShareProperties();
        }
        this.innerFileShareProperties().withEnabledProtocols(enabledProtocols);
        return this;
    }

    public RootSquashType rootSquash() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().rootSquash();
    }

    public FileShareInner withRootSquash(RootSquashType rootSquash) {
        if (this.innerFileShareProperties() == null) {
            this.innerFileShareProperties = new FileShareProperties();
        }
        this.innerFileShareProperties().withRootSquash(rootSquash);
        return this;
    }

    public String version() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().version();
    }

    public Boolean deleted() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().deleted();
    }

    public OffsetDateTime deletedTime() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().deletedTime();
    }

    public Integer remainingRetentionDays() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().remainingRetentionDays();
    }

    public ShareAccessTier accessTier() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().accessTier();
    }

    public FileShareInner withAccessTier(ShareAccessTier accessTier) {
        if (this.innerFileShareProperties() == null) {
            this.innerFileShareProperties = new FileShareProperties();
        }
        this.innerFileShareProperties().withAccessTier(accessTier);
        return this;
    }

    public OffsetDateTime accessTierChangeTime() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().accessTierChangeTime();
    }

    public String accessTierStatus() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().accessTierStatus();
    }

    public Long shareUsageBytes() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().shareUsageBytes();
    }

    public LeaseStatus leaseStatus() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().leaseStatus();
    }

    public LeaseState leaseState() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().leaseState();
    }

    public LeaseDuration leaseDuration() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().leaseDuration();
    }

    public List<SignedIdentifier> signedIdentifiers() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().signedIdentifiers();
    }

    public FileShareInner withSignedIdentifiers(List<SignedIdentifier> signedIdentifiers) {
        if (this.innerFileShareProperties() == null) {
            this.innerFileShareProperties = new FileShareProperties();
        }
        this.innerFileShareProperties().withSignedIdentifiers(signedIdentifiers);
        return this;
    }

    public OffsetDateTime snapshotTime() {
        return this.innerFileShareProperties() == null ? null : this.innerFileShareProperties().snapshotTime();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerFileShareProperties() != null) {
            this.innerFileShareProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerFileShareProperties);
        return jsonWriter.writeEndObject();
    }

    public static FileShareInner fromJson(JsonReader jsonReader) throws IOException {
        return (FileShareInner)((Object)jsonReader.readObject(reader -> {
            FileShareInner deserializedFileShareInner = new FileShareInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedFileShareInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFileShareInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFileShareInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedFileShareInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFileShareInner.innerFileShareProperties = FileShareProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileShareInner;
        }));
    }
}

