/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.BlobInventoryPolicyProperties;
import com.azure.resourcemanager.storage.models.BlobInventoryPolicySchema;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class BlobInventoryPolicyInner
extends ProxyResource {
    private BlobInventoryPolicyProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private BlobInventoryPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public BlobInventoryPolicySchema policy() {
        return this.innerProperties() == null ? null : this.innerProperties().policy();
    }

    public BlobInventoryPolicyInner withPolicy(BlobInventoryPolicySchema policy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BlobInventoryPolicyProperties();
        }
        this.innerProperties().withPolicy(policy);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BlobInventoryPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (BlobInventoryPolicyInner)((Object)jsonReader.readObject(reader -> {
            BlobInventoryPolicyInner deserializedBlobInventoryPolicyInner = new BlobInventoryPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBlobInventoryPolicyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBlobInventoryPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBlobInventoryPolicyInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBlobInventoryPolicyInner.innerProperties = BlobInventoryPolicyProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBlobInventoryPolicyInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobInventoryPolicyInner;
        }));
    }
}

