/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.IntervalUnit;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class TriggerParameters
implements JsonSerializable<TriggerParameters> {
    private OffsetDateTime startFrom;
    private Integer interval;
    private IntervalUnit intervalUnit;
    private OffsetDateTime endBy;
    private OffsetDateTime startOn;

    public OffsetDateTime startFrom() {
        return this.startFrom;
    }

    public TriggerParameters withStartFrom(OffsetDateTime startFrom) {
        this.startFrom = startFrom;
        return this;
    }

    public Integer interval() {
        return this.interval;
    }

    public TriggerParameters withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    public IntervalUnit intervalUnit() {
        return this.intervalUnit;
    }

    public TriggerParameters withIntervalUnit(IntervalUnit intervalUnit) {
        this.intervalUnit = intervalUnit;
        return this;
    }

    public OffsetDateTime endBy() {
        return this.endBy;
    }

    public TriggerParameters withEndBy(OffsetDateTime endBy) {
        this.endBy = endBy;
        return this;
    }

    public OffsetDateTime startOn() {
        return this.startOn;
    }

    public TriggerParameters withStartOn(OffsetDateTime startOn) {
        this.startOn = startOn;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startFrom", this.startFrom == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startFrom));
        jsonWriter.writeNumberField("interval", (Number)this.interval);
        jsonWriter.writeStringField("intervalUnit", this.intervalUnit == null ? null : this.intervalUnit.toString());
        jsonWriter.writeStringField("endBy", this.endBy == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endBy));
        jsonWriter.writeStringField("startOn", this.startOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startOn));
        return jsonWriter.writeEndObject();
    }

    public static TriggerParameters fromJson(JsonReader jsonReader) throws IOException {
        return (TriggerParameters)jsonReader.readObject(reader -> {
            TriggerParameters deserializedTriggerParameters = new TriggerParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startFrom".equals(fieldName)) {
                    deserializedTriggerParameters.startFrom = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedTriggerParameters.interval = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("intervalUnit".equals(fieldName)) {
                    deserializedTriggerParameters.intervalUnit = IntervalUnit.fromString(reader.getString());
                    continue;
                }
                if ("endBy".equals(fieldName)) {
                    deserializedTriggerParameters.endBy = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startOn".equals(fieldName)) {
                    deserializedTriggerParameters.startOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTriggerParameters;
        });
    }
}

