/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.BlobRestoreStatusInner;
import com.azure.resourcemanager.storage.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.storage.models.AccessTier;
import com.azure.resourcemanager.storage.models.AccountStatus;
import com.azure.resourcemanager.storage.models.AllowedCopyScope;
import com.azure.resourcemanager.storage.models.AzureFilesIdentityBasedAuthentication;
import com.azure.resourcemanager.storage.models.CustomDomain;
import com.azure.resourcemanager.storage.models.DnsEndpointType;
import com.azure.resourcemanager.storage.models.Encryption;
import com.azure.resourcemanager.storage.models.Endpoints;
import com.azure.resourcemanager.storage.models.GeoReplicationStats;
import com.azure.resourcemanager.storage.models.ImmutableStorageAccount;
import com.azure.resourcemanager.storage.models.KeyCreationTime;
import com.azure.resourcemanager.storage.models.KeyPolicy;
import com.azure.resourcemanager.storage.models.LargeFileSharesState;
import com.azure.resourcemanager.storage.models.MinimumTlsVersion;
import com.azure.resourcemanager.storage.models.NetworkRuleSet;
import com.azure.resourcemanager.storage.models.ProvisioningState;
import com.azure.resourcemanager.storage.models.PublicNetworkAccess;
import com.azure.resourcemanager.storage.models.RoutingPreference;
import com.azure.resourcemanager.storage.models.SasPolicy;
import com.azure.resourcemanager.storage.models.StorageAccountSkuConversionStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class StorageAccountPropertiesInner
implements JsonSerializable<StorageAccountPropertiesInner> {
    private ProvisioningState provisioningState;
    private Endpoints primaryEndpoints;
    private String primaryLocation;
    private AccountStatus statusOfPrimary;
    private OffsetDateTime lastGeoFailoverTime;
    private String secondaryLocation;
    private AccountStatus statusOfSecondary;
    private OffsetDateTime creationTime;
    private CustomDomain customDomain;
    private SasPolicy sasPolicy;
    private KeyPolicy keyPolicy;
    private KeyCreationTime keyCreationTime;
    private Endpoints secondaryEndpoints;
    private Encryption encryption;
    private AccessTier accessTier;
    private AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication;
    private Boolean enableHttpsTrafficOnly;
    private NetworkRuleSet networkRuleSet;
    private Boolean isSftpEnabled;
    private Boolean isLocalUserEnabled;
    private Boolean enableExtendedGroups;
    private Boolean isHnsEnabled;
    private GeoReplicationStats geoReplicationStats;
    private Boolean failoverInProgress;
    private LargeFileSharesState largeFileSharesState;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private RoutingPreference routingPreference;
    private BlobRestoreStatusInner blobRestoreStatus;
    private Boolean allowBlobPublicAccess;
    private MinimumTlsVersion minimumTlsVersion;
    private Boolean allowSharedKeyAccess;
    private Boolean enableNfsV3;
    private Boolean allowCrossTenantReplication;
    private Boolean defaultToOAuthAuthentication;
    private PublicNetworkAccess publicNetworkAccess;
    private ImmutableStorageAccount immutableStorageWithVersioning;
    private AllowedCopyScope allowedCopyScope;
    private StorageAccountSkuConversionStatus storageAccountSkuConversionStatus;
    private DnsEndpointType dnsEndpointType;
    private Boolean isSkuConversionBlocked;
    private Boolean accountMigrationInProgress;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Endpoints primaryEndpoints() {
        return this.primaryEndpoints;
    }

    public String primaryLocation() {
        return this.primaryLocation;
    }

    public AccountStatus statusOfPrimary() {
        return this.statusOfPrimary;
    }

    public OffsetDateTime lastGeoFailoverTime() {
        return this.lastGeoFailoverTime;
    }

    public String secondaryLocation() {
        return this.secondaryLocation;
    }

    public AccountStatus statusOfSecondary() {
        return this.statusOfSecondary;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public CustomDomain customDomain() {
        return this.customDomain;
    }

    public SasPolicy sasPolicy() {
        return this.sasPolicy;
    }

    public KeyPolicy keyPolicy() {
        return this.keyPolicy;
    }

    public KeyCreationTime keyCreationTime() {
        return this.keyCreationTime;
    }

    public Endpoints secondaryEndpoints() {
        return this.secondaryEndpoints;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public AccessTier accessTier() {
        return this.accessTier;
    }

    public AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication() {
        return this.azureFilesIdentityBasedAuthentication;
    }

    public StorageAccountPropertiesInner withAzureFilesIdentityBasedAuthentication(AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication) {
        this.azureFilesIdentityBasedAuthentication = azureFilesIdentityBasedAuthentication;
        return this;
    }

    public Boolean enableHttpsTrafficOnly() {
        return this.enableHttpsTrafficOnly;
    }

    public StorageAccountPropertiesInner withEnableHttpsTrafficOnly(Boolean enableHttpsTrafficOnly) {
        this.enableHttpsTrafficOnly = enableHttpsTrafficOnly;
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public Boolean isSftpEnabled() {
        return this.isSftpEnabled;
    }

    public StorageAccountPropertiesInner withIsSftpEnabled(Boolean isSftpEnabled) {
        this.isSftpEnabled = isSftpEnabled;
        return this;
    }

    public Boolean isLocalUserEnabled() {
        return this.isLocalUserEnabled;
    }

    public StorageAccountPropertiesInner withIsLocalUserEnabled(Boolean isLocalUserEnabled) {
        this.isLocalUserEnabled = isLocalUserEnabled;
        return this;
    }

    public Boolean enableExtendedGroups() {
        return this.enableExtendedGroups;
    }

    public StorageAccountPropertiesInner withEnableExtendedGroups(Boolean enableExtendedGroups) {
        this.enableExtendedGroups = enableExtendedGroups;
        return this;
    }

    public Boolean isHnsEnabled() {
        return this.isHnsEnabled;
    }

    public StorageAccountPropertiesInner withIsHnsEnabled(Boolean isHnsEnabled) {
        this.isHnsEnabled = isHnsEnabled;
        return this;
    }

    public GeoReplicationStats geoReplicationStats() {
        return this.geoReplicationStats;
    }

    public Boolean failoverInProgress() {
        return this.failoverInProgress;
    }

    public LargeFileSharesState largeFileSharesState() {
        return this.largeFileSharesState;
    }

    public StorageAccountPropertiesInner withLargeFileSharesState(LargeFileSharesState largeFileSharesState) {
        this.largeFileSharesState = largeFileSharesState;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public RoutingPreference routingPreference() {
        return this.routingPreference;
    }

    public StorageAccountPropertiesInner withRoutingPreference(RoutingPreference routingPreference) {
        this.routingPreference = routingPreference;
        return this;
    }

    public BlobRestoreStatusInner blobRestoreStatus() {
        return this.blobRestoreStatus;
    }

    public Boolean allowBlobPublicAccess() {
        return this.allowBlobPublicAccess;
    }

    public StorageAccountPropertiesInner withAllowBlobPublicAccess(Boolean allowBlobPublicAccess) {
        this.allowBlobPublicAccess = allowBlobPublicAccess;
        return this;
    }

    public MinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public StorageAccountPropertiesInner withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public Boolean allowSharedKeyAccess() {
        return this.allowSharedKeyAccess;
    }

    public StorageAccountPropertiesInner withAllowSharedKeyAccess(Boolean allowSharedKeyAccess) {
        this.allowSharedKeyAccess = allowSharedKeyAccess;
        return this;
    }

    public Boolean enableNfsV3() {
        return this.enableNfsV3;
    }

    public StorageAccountPropertiesInner withEnableNfsV3(Boolean enableNfsV3) {
        this.enableNfsV3 = enableNfsV3;
        return this;
    }

    public Boolean allowCrossTenantReplication() {
        return this.allowCrossTenantReplication;
    }

    public StorageAccountPropertiesInner withAllowCrossTenantReplication(Boolean allowCrossTenantReplication) {
        this.allowCrossTenantReplication = allowCrossTenantReplication;
        return this;
    }

    public Boolean defaultToOAuthAuthentication() {
        return this.defaultToOAuthAuthentication;
    }

    public StorageAccountPropertiesInner withDefaultToOAuthAuthentication(Boolean defaultToOAuthAuthentication) {
        this.defaultToOAuthAuthentication = defaultToOAuthAuthentication;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public StorageAccountPropertiesInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public ImmutableStorageAccount immutableStorageWithVersioning() {
        return this.immutableStorageWithVersioning;
    }

    public StorageAccountPropertiesInner withImmutableStorageWithVersioning(ImmutableStorageAccount immutableStorageWithVersioning) {
        this.immutableStorageWithVersioning = immutableStorageWithVersioning;
        return this;
    }

    public AllowedCopyScope allowedCopyScope() {
        return this.allowedCopyScope;
    }

    public StorageAccountPropertiesInner withAllowedCopyScope(AllowedCopyScope allowedCopyScope) {
        this.allowedCopyScope = allowedCopyScope;
        return this;
    }

    public StorageAccountSkuConversionStatus storageAccountSkuConversionStatus() {
        return this.storageAccountSkuConversionStatus;
    }

    public StorageAccountPropertiesInner withStorageAccountSkuConversionStatus(StorageAccountSkuConversionStatus storageAccountSkuConversionStatus) {
        this.storageAccountSkuConversionStatus = storageAccountSkuConversionStatus;
        return this;
    }

    public DnsEndpointType dnsEndpointType() {
        return this.dnsEndpointType;
    }

    public StorageAccountPropertiesInner withDnsEndpointType(DnsEndpointType dnsEndpointType) {
        this.dnsEndpointType = dnsEndpointType;
        return this;
    }

    public Boolean isSkuConversionBlocked() {
        return this.isSkuConversionBlocked;
    }

    public Boolean accountMigrationInProgress() {
        return this.accountMigrationInProgress;
    }

    public void validate() {
        if (this.primaryEndpoints() != null) {
            this.primaryEndpoints().validate();
        }
        if (this.customDomain() != null) {
            this.customDomain().validate();
        }
        if (this.sasPolicy() != null) {
            this.sasPolicy().validate();
        }
        if (this.keyPolicy() != null) {
            this.keyPolicy().validate();
        }
        if (this.keyCreationTime() != null) {
            this.keyCreationTime().validate();
        }
        if (this.secondaryEndpoints() != null) {
            this.secondaryEndpoints().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.azureFilesIdentityBasedAuthentication() != null) {
            this.azureFilesIdentityBasedAuthentication().validate();
        }
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.geoReplicationStats() != null) {
            this.geoReplicationStats().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.routingPreference() != null) {
            this.routingPreference().validate();
        }
        if (this.blobRestoreStatus() != null) {
            this.blobRestoreStatus().validate();
        }
        if (this.immutableStorageWithVersioning() != null) {
            this.immutableStorageWithVersioning().validate();
        }
        if (this.storageAccountSkuConversionStatus() != null) {
            this.storageAccountSkuConversionStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azureFilesIdentityBasedAuthentication", (JsonSerializable)this.azureFilesIdentityBasedAuthentication);
        jsonWriter.writeBooleanField("supportsHttpsTrafficOnly", this.enableHttpsTrafficOnly);
        jsonWriter.writeBooleanField("isSftpEnabled", this.isSftpEnabled);
        jsonWriter.writeBooleanField("isLocalUserEnabled", this.isLocalUserEnabled);
        jsonWriter.writeBooleanField("enableExtendedGroups", this.enableExtendedGroups);
        jsonWriter.writeBooleanField("isHnsEnabled", this.isHnsEnabled);
        jsonWriter.writeStringField("largeFileSharesState", this.largeFileSharesState == null ? null : this.largeFileSharesState.toString());
        jsonWriter.writeJsonField("routingPreference", (JsonSerializable)this.routingPreference);
        jsonWriter.writeBooleanField("allowBlobPublicAccess", this.allowBlobPublicAccess);
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion == null ? null : this.minimumTlsVersion.toString());
        jsonWriter.writeBooleanField("allowSharedKeyAccess", this.allowSharedKeyAccess);
        jsonWriter.writeBooleanField("isNfsV3Enabled", this.enableNfsV3);
        jsonWriter.writeBooleanField("allowCrossTenantReplication", this.allowCrossTenantReplication);
        jsonWriter.writeBooleanField("defaultToOAuthAuthentication", this.defaultToOAuthAuthentication);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("immutableStorageWithVersioning", (JsonSerializable)this.immutableStorageWithVersioning);
        jsonWriter.writeStringField("allowedCopyScope", this.allowedCopyScope == null ? null : this.allowedCopyScope.toString());
        jsonWriter.writeJsonField("storageAccountSkuConversionStatus", (JsonSerializable)this.storageAccountSkuConversionStatus);
        jsonWriter.writeStringField("dnsEndpointType", this.dnsEndpointType == null ? null : this.dnsEndpointType.toString());
        return jsonWriter.writeEndObject();
    }

    public static StorageAccountPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (StorageAccountPropertiesInner)jsonReader.readObject(reader -> {
            StorageAccountPropertiesInner deserializedStorageAccountPropertiesInner = new StorageAccountPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("primaryEndpoints".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.primaryEndpoints = Endpoints.fromJson(reader);
                    continue;
                }
                if ("primaryLocation".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.primaryLocation = reader.getString();
                    continue;
                }
                if ("statusOfPrimary".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.statusOfPrimary = AccountStatus.fromString(reader.getString());
                    continue;
                }
                if ("lastGeoFailoverTime".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.lastGeoFailoverTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("secondaryLocation".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.secondaryLocation = reader.getString();
                    continue;
                }
                if ("statusOfSecondary".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.statusOfSecondary = AccountStatus.fromString(reader.getString());
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("customDomain".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.customDomain = CustomDomain.fromJson(reader);
                    continue;
                }
                if ("sasPolicy".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.sasPolicy = SasPolicy.fromJson(reader);
                    continue;
                }
                if ("keyPolicy".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.keyPolicy = KeyPolicy.fromJson(reader);
                    continue;
                }
                if ("keyCreationTime".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.keyCreationTime = KeyCreationTime.fromJson(reader);
                    continue;
                }
                if ("secondaryEndpoints".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.secondaryEndpoints = Endpoints.fromJson(reader);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.encryption = Encryption.fromJson(reader);
                    continue;
                }
                if ("accessTier".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.accessTier = AccessTier.fromString(reader.getString());
                    continue;
                }
                if ("azureFilesIdentityBasedAuthentication".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.azureFilesIdentityBasedAuthentication = AzureFilesIdentityBasedAuthentication.fromJson(reader);
                    continue;
                }
                if ("supportsHttpsTrafficOnly".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.enableHttpsTrafficOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("networkAcls".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.networkRuleSet = NetworkRuleSet.fromJson(reader);
                    continue;
                }
                if ("isSftpEnabled".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.isSftpEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isLocalUserEnabled".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.isLocalUserEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableExtendedGroups".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.enableExtendedGroups = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isHnsEnabled".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.isHnsEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("geoReplicationStats".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.geoReplicationStats = GeoReplicationStats.fromJson(reader);
                    continue;
                }
                if ("failoverInProgress".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.failoverInProgress = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("largeFileSharesState".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.largeFileSharesState = LargeFileSharesState.fromString(reader.getString());
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedStorageAccountPropertiesInner.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("routingPreference".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.routingPreference = RoutingPreference.fromJson(reader);
                    continue;
                }
                if ("blobRestoreStatus".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.blobRestoreStatus = BlobRestoreStatusInner.fromJson(reader);
                    continue;
                }
                if ("allowBlobPublicAccess".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.allowBlobPublicAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.minimumTlsVersion = MinimumTlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("allowSharedKeyAccess".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.allowSharedKeyAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isNfsV3Enabled".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.enableNfsV3 = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowCrossTenantReplication".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.allowCrossTenantReplication = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultToOAuthAuthentication".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.defaultToOAuthAuthentication = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("immutableStorageWithVersioning".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.immutableStorageWithVersioning = ImmutableStorageAccount.fromJson(reader);
                    continue;
                }
                if ("allowedCopyScope".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.allowedCopyScope = AllowedCopyScope.fromString(reader.getString());
                    continue;
                }
                if ("storageAccountSkuConversionStatus".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.storageAccountSkuConversionStatus = StorageAccountSkuConversionStatus.fromJson(reader);
                    continue;
                }
                if ("dnsEndpointType".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.dnsEndpointType = DnsEndpointType.fromString(reader.getString());
                    continue;
                }
                if ("isSkuConversionBlocked".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.isSkuConversionBlocked = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("accountMigrationInProgress".equals(fieldName)) {
                    deserializedStorageAccountPropertiesInner.accountMigrationInProgress = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccountPropertiesInner;
        });
    }
}

