// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.BlobServicePropertiesInner;
import java.io.IOException;
import java.util.List;

/**
 * The BlobServiceItems model.
 */
@Immutable
public final class BlobServiceItems implements JsonSerializable<BlobServiceItems> {
    /*
     * List of blob services returned.
     */
    private List<BlobServicePropertiesInner> value;

    /**
     * Creates an instance of BlobServiceItems class.
     */
    public BlobServiceItems() {
    }

    /**
     * Get the value property: List of blob services returned.
     * 
     * @return the value value.
     */
    public List<BlobServicePropertiesInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BlobServiceItems from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BlobServiceItems if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BlobServiceItems.
     */
    public static BlobServiceItems fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BlobServiceItems deserializedBlobServiceItems = new BlobServiceItems();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<BlobServicePropertiesInner> value
                        = reader.readArray(reader1 -> BlobServicePropertiesInner.fromJson(reader1));
                    deserializedBlobServiceItems.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBlobServiceItems;
        });
    }
}
