// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An object that defines the blob inventory rule filter conditions. For 'Blob' definition.objectType all filter
 * properties are applicable, 'blobTypes' is required and others are optional. For 'Container' definition.objectType
 * only prefixMatch is applicable and is optional.
 */
@Fluent
public final class BlobInventoryPolicyFilter implements JsonSerializable<BlobInventoryPolicyFilter> {
    /*
     * An array of strings with maximum 10 blob prefixes to be included in the inventory.
     */
    private List<String> prefixMatch;

    /*
     * An array of strings with maximum 10 blob prefixes to be excluded from the inventory.
     */
    private List<String> excludePrefix;

    /*
     * An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not
     * support pageBlobs. This field is required when definition.objectType property is set to 'Blob'.
     */
    private List<String> blobTypes;

    /*
     * Includes blob versions in blob inventory when value is set to true. The definition.schemaFields values 'VersionId
     * and IsCurrentVersion' are required if this property is set to true, else they must be excluded.
     */
    private Boolean includeBlobVersions;

    /*
     * Includes blob snapshots in blob inventory when value is set to true. The definition.schemaFields value 'Snapshot'
     * is required if this property is set to true, else it must be excluded.
     */
    private Boolean includeSnapshots;

    /*
     * For 'Container' definition.objectType the definition.schemaFields must include 'Deleted, Version, DeletedTime and
     * RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled storage accounts the
     * definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for Hns
     * disabled accounts the definition.schemaFields must include 'Deleted and RemainingRetentionDays', else it must be
     * excluded.
     */
    private Boolean includeDeleted;

    /*
     * This property is used to filter objects based on the object creation time
     */
    private BlobInventoryCreationTime creationTime;

    /**
     * Creates an instance of BlobInventoryPolicyFilter class.
     */
    public BlobInventoryPolicyFilter() {
    }

    /**
     * Get the prefixMatch property: An array of strings with maximum 10 blob prefixes to be included in the inventory.
     * 
     * @return the prefixMatch value.
     */
    public List<String> prefixMatch() {
        return this.prefixMatch;
    }

    /**
     * Set the prefixMatch property: An array of strings with maximum 10 blob prefixes to be included in the inventory.
     * 
     * @param prefixMatch the prefixMatch value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withPrefixMatch(List<String> prefixMatch) {
        this.prefixMatch = prefixMatch;
        return this;
    }

    /**
     * Get the excludePrefix property: An array of strings with maximum 10 blob prefixes to be excluded from the
     * inventory.
     * 
     * @return the excludePrefix value.
     */
    public List<String> excludePrefix() {
        return this.excludePrefix;
    }

    /**
     * Set the excludePrefix property: An array of strings with maximum 10 blob prefixes to be excluded from the
     * inventory.
     * 
     * @param excludePrefix the excludePrefix value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withExcludePrefix(List<String> excludePrefix) {
        this.excludePrefix = excludePrefix;
        return this;
    }

    /**
     * Get the blobTypes property: An array of predefined enum values. Valid values include blockBlob, appendBlob,
     * pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is
     * set to 'Blob'.
     * 
     * @return the blobTypes value.
     */
    public List<String> blobTypes() {
        return this.blobTypes;
    }

    /**
     * Set the blobTypes property: An array of predefined enum values. Valid values include blockBlob, appendBlob,
     * pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is
     * set to 'Blob'.
     * 
     * @param blobTypes the blobTypes value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withBlobTypes(List<String> blobTypes) {
        this.blobTypes = blobTypes;
        return this;
    }

    /**
     * Get the includeBlobVersions property: Includes blob versions in blob inventory when value is set to true. The
     * definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this property is set to true,
     * else they must be excluded.
     * 
     * @return the includeBlobVersions value.
     */
    public Boolean includeBlobVersions() {
        return this.includeBlobVersions;
    }

    /**
     * Set the includeBlobVersions property: Includes blob versions in blob inventory when value is set to true. The
     * definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this property is set to true,
     * else they must be excluded.
     * 
     * @param includeBlobVersions the includeBlobVersions value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withIncludeBlobVersions(Boolean includeBlobVersions) {
        this.includeBlobVersions = includeBlobVersions;
        return this;
    }

    /**
     * Get the includeSnapshots property: Includes blob snapshots in blob inventory when value is set to true. The
     * definition.schemaFields value 'Snapshot' is required if this property is set to true, else it must be excluded.
     * 
     * @return the includeSnapshots value.
     */
    public Boolean includeSnapshots() {
        return this.includeSnapshots;
    }

    /**
     * Set the includeSnapshots property: Includes blob snapshots in blob inventory when value is set to true. The
     * definition.schemaFields value 'Snapshot' is required if this property is set to true, else it must be excluded.
     * 
     * @param includeSnapshots the includeSnapshots value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withIncludeSnapshots(Boolean includeSnapshots) {
        this.includeSnapshots = includeSnapshots;
        return this;
    }

    /**
     * Get the includeDeleted property: For 'Container' definition.objectType the definition.schemaFields must include
     * 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled
     * storage accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and
     * RemainingRetentionDays' and for Hns disabled accounts the definition.schemaFields must include 'Deleted and
     * RemainingRetentionDays', else it must be excluded.
     * 
     * @return the includeDeleted value.
     */
    public Boolean includeDeleted() {
        return this.includeDeleted;
    }

    /**
     * Set the includeDeleted property: For 'Container' definition.objectType the definition.schemaFields must include
     * 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled
     * storage accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and
     * RemainingRetentionDays' and for Hns disabled accounts the definition.schemaFields must include 'Deleted and
     * RemainingRetentionDays', else it must be excluded.
     * 
     * @param includeDeleted the includeDeleted value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
    }

    /**
     * Get the creationTime property: This property is used to filter objects based on the object creation time.
     * 
     * @return the creationTime value.
     */
    public BlobInventoryCreationTime creationTime() {
        return this.creationTime;
    }

    /**
     * Set the creationTime property: This property is used to filter objects based on the object creation time.
     * 
     * @param creationTime the creationTime value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withCreationTime(BlobInventoryCreationTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (creationTime() != null) {
            creationTime().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("prefixMatch", this.prefixMatch, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("excludePrefix", this.excludePrefix,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("blobTypes", this.blobTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("includeBlobVersions", this.includeBlobVersions);
        jsonWriter.writeBooleanField("includeSnapshots", this.includeSnapshots);
        jsonWriter.writeBooleanField("includeDeleted", this.includeDeleted);
        jsonWriter.writeJsonField("creationTime", this.creationTime);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BlobInventoryPolicyFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BlobInventoryPolicyFilter if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BlobInventoryPolicyFilter.
     */
    public static BlobInventoryPolicyFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BlobInventoryPolicyFilter deserializedBlobInventoryPolicyFilter = new BlobInventoryPolicyFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("prefixMatch".equals(fieldName)) {
                    List<String> prefixMatch = reader.readArray(reader1 -> reader1.getString());
                    deserializedBlobInventoryPolicyFilter.prefixMatch = prefixMatch;
                } else if ("excludePrefix".equals(fieldName)) {
                    List<String> excludePrefix = reader.readArray(reader1 -> reader1.getString());
                    deserializedBlobInventoryPolicyFilter.excludePrefix = excludePrefix;
                } else if ("blobTypes".equals(fieldName)) {
                    List<String> blobTypes = reader.readArray(reader1 -> reader1.getString());
                    deserializedBlobInventoryPolicyFilter.blobTypes = blobTypes;
                } else if ("includeBlobVersions".equals(fieldName)) {
                    deserializedBlobInventoryPolicyFilter.includeBlobVersions
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("includeSnapshots".equals(fieldName)) {
                    deserializedBlobInventoryPolicyFilter.includeSnapshots = reader.getNullable(JsonReader::getBoolean);
                } else if ("includeDeleted".equals(fieldName)) {
                    deserializedBlobInventoryPolicyFilter.includeDeleted = reader.getNullable(JsonReader::getBoolean);
                } else if ("creationTime".equals(fieldName)) {
                    deserializedBlobInventoryPolicyFilter.creationTime = BlobInventoryCreationTime.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBlobInventoryPolicyFilter;
        });
    }
}
