// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The AccessPolicy model.
 */
@Fluent
public final class AccessPolicy implements JsonSerializable<AccessPolicy> {
    /*
     * Start time of the access policy
     */
    private OffsetDateTime startTime;

    /*
     * Expiry time of the access policy
     */
    private OffsetDateTime expiryTime;

    /*
     * List of abbreviated permissions.
     */
    private String permission;

    /**
     * Creates an instance of AccessPolicy class.
     */
    public AccessPolicy() {
    }

    /**
     * Get the startTime property: Start time of the access policy.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Start time of the access policy.
     * 
     * @param startTime the startTime value to set.
     * @return the AccessPolicy object itself.
     */
    public AccessPolicy withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the expiryTime property: Expiry time of the access policy.
     * 
     * @return the expiryTime value.
     */
    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    /**
     * Set the expiryTime property: Expiry time of the access policy.
     * 
     * @param expiryTime the expiryTime value to set.
     * @return the AccessPolicy object itself.
     */
    public AccessPolicy withExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    /**
     * Get the permission property: List of abbreviated permissions.
     * 
     * @return the permission value.
     */
    public String permission() {
        return this.permission;
    }

    /**
     * Set the permission property: List of abbreviated permissions.
     * 
     * @param permission the permission value to set.
     * @return the AccessPolicy object itself.
     */
    public AccessPolicy withPermission(String permission) {
        this.permission = permission;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("expiryTime",
            this.expiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiryTime));
        jsonWriter.writeStringField("permission", this.permission);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessPolicy if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AccessPolicy.
     */
    public static AccessPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessPolicy deserializedAccessPolicy = new AccessPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startTime".equals(fieldName)) {
                    deserializedAccessPolicy.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("expiryTime".equals(fieldName)) {
                    deserializedAccessPolicy.expiryTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("permission".equals(fieldName)) {
                    deserializedAccessPolicy.permission = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessPolicy;
        });
    }
}
