/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.BlobInventoryPolicySchema;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class BlobInventoryPolicyProperties
implements JsonSerializable<BlobInventoryPolicyProperties> {
    private OffsetDateTime lastModifiedTime;
    private BlobInventoryPolicySchema policy;
    private static final ClientLogger LOGGER = new ClientLogger(BlobInventoryPolicyProperties.class);

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public BlobInventoryPolicySchema policy() {
        return this.policy;
    }

    public BlobInventoryPolicyProperties withPolicy(BlobInventoryPolicySchema policy) {
        this.policy = policy;
        return this;
    }

    public void validate() {
        if (this.policy() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property policy in model BlobInventoryPolicyProperties"));
        }
        this.policy().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        return jsonWriter.writeEndObject();
    }

    public static BlobInventoryPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BlobInventoryPolicyProperties)jsonReader.readObject(reader -> {
            BlobInventoryPolicyProperties deserializedBlobInventoryPolicyProperties = new BlobInventoryPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policy".equals(fieldName)) {
                    deserializedBlobInventoryPolicyProperties.policy = BlobInventoryPolicySchema.fromJson(reader);
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedBlobInventoryPolicyProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobInventoryPolicyProperties;
        });
    }
}

