// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Virtual Network rule.
 */
@Fluent
public final class VirtualNetworkRule {
    /*
     * Resource ID of a subnet, for example:
     * /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}
     * /subnets/{subnetName}.
     */
    @JsonProperty(value = "id", required = true)
    private String virtualNetworkResourceId;

    /*
     * The action of virtual network rule.
     */
    @JsonProperty(value = "action")
    private Action action;

    /*
     * Gets the state of virtual network rule.
     */
    @JsonProperty(value = "state")
    private State state;

    /**
     * Creates an instance of VirtualNetworkRule class.
     */
    public VirtualNetworkRule() {
    }

    /**
     * Get the virtualNetworkResourceId property: Resource ID of a subnet, for example:
     * /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     * 
     * @return the virtualNetworkResourceId value.
     */
    public String virtualNetworkResourceId() {
        return this.virtualNetworkResourceId;
    }

    /**
     * Set the virtualNetworkResourceId property: Resource ID of a subnet, for example:
     * /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     * 
     * @param virtualNetworkResourceId the virtualNetworkResourceId value to set.
     * @return the VirtualNetworkRule object itself.
     */
    public VirtualNetworkRule withVirtualNetworkResourceId(String virtualNetworkResourceId) {
        this.virtualNetworkResourceId = virtualNetworkResourceId;
        return this;
    }

    /**
     * Get the action property: The action of virtual network rule.
     * 
     * @return the action value.
     */
    public Action action() {
        return this.action;
    }

    /**
     * Set the action property: The action of virtual network rule.
     * 
     * @param action the action value to set.
     * @return the VirtualNetworkRule object itself.
     */
    public VirtualNetworkRule withAction(Action action) {
        this.action = action;
        return this;
    }

    /**
     * Get the state property: Gets the state of virtual network rule.
     * 
     * @return the state value.
     */
    public State state() {
        return this.state;
    }

    /**
     * Set the state property: Gets the state of virtual network rule.
     * 
     * @param state the state value to set.
     * @return the VirtualNetworkRule object itself.
     */
    public VirtualNetworkRule withState(State state) {
        this.state = state;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (virtualNetworkResourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property virtualNetworkResourceId in model VirtualNetworkRule"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkRule.class);
}
