// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The trigger type of the storage task assignment execution.
 */
public enum TriggerType {
    /**
     * Enum value RunOnce.
     */
    RUN_ONCE("RunOnce"),

    /**
     * Enum value OnSchedule.
     */
    ON_SCHEDULE("OnSchedule");

    /**
     * The actual serialized value for a TriggerType instance.
     */
    private final String value;

    TriggerType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a TriggerType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed TriggerType object, or null if unable to parse.
     */
    @JsonCreator
    public static TriggerType fromString(String value) {
        if (value == null) {
            return null;
        }
        TriggerType[] items = TriggerType.values();
        for (TriggerType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
